/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rpc.auth;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheManager;
import com.atlassian.confluence.event.events.security.RpcAuthenticatedEvent;
import com.atlassian.confluence.rpc.AuthenticationFailedException;
import com.atlassian.confluence.rpc.InvalidSessionException;
import com.atlassian.confluence.rpc.NotPermittedException;
import com.atlassian.confluence.rpc.RemoteException;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.core.util.RandomGenerator;
import com.atlassian.event.Event;
import com.atlassian.event.EventManager;
import com.atlassian.user.User;
import org.apache.log4j.Category;

public class TokenAuthenticationManager {
    public static final Category log = Category.getInstance(TokenAuthenticationManager.class);
    public static final String TOKEN_CACHE = TokenAuthenticationManager.class.getName() + ".tokens";
    private UserAccessor userAccessor;
    private PermissionManager permissionManager;
    private SettingsManager settingsManager;
    private CacheManager cacheManager;
    private EventManager eventManager;

    public String login(String username, String password) throws RemoteException {
        User user = this.userAccessor.getUser(username);
        if (user == null) {
            throw new AuthenticationFailedException("Attempt to login user '" + username + "' failed - no user could be found with this username.");
        }
        boolean authenticated = this.userAccessor.authenticate(username, password);
        if (!authenticated) {
            throw new AuthenticationFailedException("Attempt to login user '" + username + "' failed - incorrect password.");
        }
        String token = this.createToken(user);
        this.eventManager.publishEvent((Event)new RpcAuthenticatedEvent(this, user, token));
        return token;
    }

    public boolean logout(String token) throws Exception {
        Cache cache = this.getCache();
        Object value = cache.get((Object)token);
        if (value == null) {
            return false;
        }
        cache.remove((Object)token);
        return true;
    }

    private String createToken(User user) throws RemoteException {
        String token = RandomGenerator.randomString((int)10);
        Cache cache = this.getCache();
        int count = 0;
        while (cache.get((Object)token) != null && count++ < 10) {
            token = RandomGenerator.randomString((int)10);
        }
        if (count >= 10) {
            throw new RemoteException("Error generating auth token - what the?");
        }
        cache.put((Object)token, (Object)user.getName());
        return token;
    }

    public void setUserAccessor(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }

    public void setSettingsManager(SettingsManager settingsManager) {
        this.settingsManager = settingsManager;
    }

    public void setPermissionManager(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public void setEventManager(EventManager eventManager) {
        this.eventManager = eventManager;
    }

    public User makeNonAnonymousUserFromToken(String token) throws InvalidSessionException {
        User user = this.retrieveUser(token);
        if (user == null) {
            throw new InvalidSessionException("User not authenticated or session expired. Call login() to open a new session");
        }
        return user;
    }

    public User makeAnonymousUser() throws NotPermittedException {
        if (!this.settingsManager.getGlobalSettings().isAllowRemoteApiAnonymous()) {
            throw new NotPermittedException("Anonymous RPC access is disabled on this server");
        }
        return null;
    }

    public boolean hasUseConfluencePermission(User user) {
        return this.permissionManager.hasPermission(user, Permission.VIEW, PermissionManager.TARGET_APPLICATION);
    }

    private User retrieveUser(String token) {
        String name = (String)this.getCache().get((Object)token);
        return this.userAccessor.getUser(name);
    }

    private Cache getCache() {
        return this.cacheManager.getCache(TOKEN_CACHE);
    }
}

