/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rpc.soap;

import com.atlassian.confluence.plugin.descriptor.rpc.SoapModuleDescriptor;
import com.atlassian.confluence.rpc.soap.ConfluenceAxisSoapService;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.spring.container.ContainerManager;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.axis.AxisFault;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.configuration.SimpleProvider;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.server.AxisServer;
import org.apache.axis.server.DefaultAxisServerFactory;

public class ConfluenceAxisServerFactory
extends DefaultAxisServerFactory {
    public AxisServer getServer(Map environment) throws AxisFault {
        EngineConfiguration defaultConfig = null;
        if (environment != null) {
            try {
                defaultConfig = (EngineConfiguration)environment.get("engineConfig");
            }
            catch (ClassCastException e) {
                log.warn((Object)e);
            }
        } else {
            environment = new HashMap<String, SimpleProvider>();
        }
        SimpleProvider newConfig = new SimpleProvider(defaultConfig);
        List soapDescriptors = ((PluginAccessor)ContainerManager.getComponent((String)"pluginAccessor")).getEnabledModuleDescriptorsByClass(SoapModuleDescriptor.class);
        Iterator iterator = soapDescriptors.iterator();
        while (iterator.hasNext()) {
            try {
                SoapModuleDescriptor descriptor = (SoapModuleDescriptor)((Object)iterator.next());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Publishing to " + descriptor.getServicePath() + " module " + descriptor.getModuleClass() + " with interface " + descriptor.getPublishedInterface()));
                }
                ConfluenceAxisSoapService soapService = new ConfluenceAxisSoapService(descriptor);
                newConfig.deployService(soapService.getName(), (SOAPService)soapService);
            }
            catch (Throwable e) {
                log.warn((Object)("Error registering soap service: " + e), e);
            }
        }
        environment.put("engineConfig", newConfig);
        return super.getServer(environment);
    }
}

