/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rpc.xmlrpc;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Vector;
import org.apache.xmlrpc.XmlRpcClient;
import org.apache.xmlrpc.XmlRpcException;

public class RPCSpaceExporter {
    static String url;
    static String username;
    static String password;
    static String spaceKey;
    static String exportType;
    static String downloadURL;

    public static void main(String[] args) {
        if (args.length < 5) {
            RPCSpaceExporter.usage();
            System.exit(0);
        }
        url = args[0];
        username = args[1];
        password = args[2];
        spaceKey = args[3];
        exportType = args[4];
        if (url == null || username == null || password == null || spaceKey == null) {
            RPCSpaceExporter.usage();
            System.exit(0);
        }
        XmlRpcClient xmlrpc = null;
        try {
            xmlrpc = new XmlRpcClient(url);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        try {
            Vector<String> params = new Vector<String>();
            params.add(username);
            params.add(password);
            String token = (String)xmlrpc.execute("confluence1.login", params);
            params = new Vector();
            params.add(token);
            params.add(spaceKey);
            params.add(exportType);
            downloadURL = (String)xmlrpc.execute("confluence1.exportSpace", params);
        }
        catch (XmlRpcException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String finalURL = downloadURL + "?os_username=" + username + "&os_password=" + password;
        System.out.println(finalURL);
    }

    private static void usage() {
        System.out.println("Current parameters");
        System.out.println("Confluence URL: [" + url + "]");
        System.out.println("username: [" + username + "]");
        if (password == null) {
            System.out.println("password: [" + password + "]");
        } else {
            System.out.println("password: [ <private> ]");
        }
        System.out.println("spacekey: [" + spaceKey + "]");
        System.out.println("exportType: [" + exportType + "]");
        System.out.println("- - - -");
        System.out.println("Requires the following arguments");
        System.out.println("Confluence URL: args[0]");
        System.out.println("username: args[1]");
        System.out.println("password: args[2]");
        System.out.println("spacekey: args[3]");
        System.out.println("exportType: args[4]");
    }
}

