/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rpc.xmlrpc;

import com.atlassian.confluence.plugin.descriptor.rpc.XmlRpcModuleDescriptor;
import com.atlassian.confluence.rpc.RpcServer;
import com.atlassian.confluence.rpc.auth.TokenAuthenticationInvocationHandler;
import com.atlassian.confluence.servlet.ServletManager;
import com.atlassian.confluence.servlet.SpringManagedServlet;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.util.profiling.ProfilingPageFilter;
import com.atlassian.plugin.PluginAccessor;
import com.opensymphony.webwork.ServletActionContext;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Category;
import org.apache.xmlrpc.XmlRpc;

public class XmlRpcServer
implements ServletManager,
RpcServer {
    public static final Category log = Category.getInstance(XmlRpcServer.class);
    private org.apache.xmlrpc.XmlRpcServer xmlrpc;
    private PluginAccessor pluginAccessor;
    private SettingsManager settingsManager;
    private static final String SAX_DRIVER_SYSTEM_PROPERTY = "confluence.rpc.xml.sax.driver";
    private static final String DEFAULT_SAX_DRIVER = "xerces";

    private static void configureSaxDriver() {
        String xmlRpcSaxDriver = null;
        try {
            xmlRpcSaxDriver = System.getProperty(SAX_DRIVER_SYSTEM_PROPERTY, DEFAULT_SAX_DRIVER);
            XmlRpc.setDriver((String)xmlRpcSaxDriver);
        }
        catch (ClassNotFoundException e) {
            log.warn((Object)("Unable to load " + xmlRpcSaxDriver + " as XML-RPC server SAX parser. Using default (MinML)."), (Throwable)e);
        }
    }

    public void reloadConfiguration() {
        if (this.xmlrpc == null) {
            log.debug((Object)"Deferring XML-RPC reload until first request");
            return;
        }
        log.info((Object)"Removing RPC handler for reload");
        this.xmlrpc = null;
    }

    public void servletDestroyed(SpringManagedServlet springManagedServlet) {
    }

    public void service(SpringManagedServlet springManagedServlet, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!this.settingsManager.getGlobalSettings().isAllowRemoteApi()) {
            response.sendError(403, "Remote API is not enabled on this server. Ask a site administrator to enable it.");
            return;
        }
        if (request.getMethod().equals("GET") || request.getMethod().equals("POST")) {
            try {
                this.serviceXmlRpcRequest(request, response);
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
            }
        } else {
            response.sendError(405, "XML-RPC only supports GET or POST requests");
        }
    }

    private void serviceXmlRpcRequest(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        ServletInputStream is = null;
        try {
            if (this.xmlrpc == null) {
                this.loadRpcHandler();
            }
            ServletActionContext.setRequest((HttpServletRequest)request);
            ServletActionContext.setResponse((HttpServletResponse)response);
            is = request.getInputStream();
            byte[] result = this.xmlrpc.execute((InputStream)is);
            response.setContentType("text/xml");
            response.setContentLength(result.length);
            ServletOutputStream out = response.getOutputStream();
            out.write(result);
            out.flush();
        }
        catch (RuntimeException e) {
            try {
                log.error((Object)("Exception servicing XML-RPC request: " + e), (Throwable)e);
                throw new ServletException((Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                ServletActionContext.setRequest(null);
                ServletActionContext.setResponse(null);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)is);
        ServletActionContext.setRequest(null);
        ServletActionContext.setResponse(null);
    }

    public void servletInitialised(SpringManagedServlet springManagedServlet, ServletConfig servletConfig) throws ServletException {
        log.info((Object)"Initialising XML-RPC service (servlet init)");
        ProfilingPageFilter.ensureFactorySetup(servletConfig);
        this.loadRpcHandler();
    }

    private void loadRpcHandler() {
        log.info((Object)"Loading XML-RPC handlers");
        this.xmlrpc = new org.apache.xmlrpc.XmlRpcServer();
        List handlers = this.pluginAccessor.getEnabledModuleDescriptorsByClass(XmlRpcModuleDescriptor.class);
        for (XmlRpcModuleDescriptor descriptor : handlers) {
            log.info((Object)("Adding handler: " + descriptor.getServicePath() + " (" + descriptor.getCompleteKey() + ")"));
            try {
                Object handler = descriptor.getModule();
                if (descriptor.isAuthenticated()) {
                    handler = TokenAuthenticationInvocationHandler.makeAuthenticatingProxy(handler, descriptor.getPublishedInterface());
                }
                this.xmlrpc.addHandler(descriptor.getServicePath(), handler);
            }
            catch (Exception e) {
                log.error((Object)("Unable to add XML-RPC handler: " + descriptor.getCompleteKey() + " - " + e), (Throwable)e);
            }
        }
    }

    public void setPluginAccessor(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    public void setSettingsManager(SettingsManager settingsManager) {
        this.settingsManager = settingsManager;
    }

    static {
        XmlRpcServer.configureSaxDriver();
    }
}

