/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rss;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.rss.RssRenderItem;
import com.atlassian.confluence.rss.RssRenderSupport;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.ConfluenceRenderUtils;
import com.atlassian.confluence.util.LabelUtil;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.atlassian.renderer.WikiStyleRenderer;
import com.sun.syndication.feed.synd.SyndCategoryImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class AbstractContentEntityRenderSupport
implements RssRenderSupport {
    protected WikiStyleRenderer wikiStyleRenderer;
    protected SettingsManager settingsManager;
    protected UserAccessor userAccessor;
    protected WebResourceManager webResourceManager;

    public List getCategories(RssRenderItem item) {
        ArrayList<SyndCategoryImpl> categories = new ArrayList<SyndCategoryImpl>();
        ContentEntityObject contentEntityObject = this.getContentEntityObject(item);
        List labels = contentEntityObject.getLabels();
        List filteredLabels = LabelUtil.getVisibleLabelNames(labels, AuthenticatedUserThreadLocal.getUsername());
        for (String labelname : filteredLabels) {
            SyndCategoryImpl category = new SyndCategoryImpl();
            category.setName(labelname);
            categories.add(category);
        }
        return categories;
    }

    public String getLink(RssRenderItem item) {
        return this.getContentEntityObject(item).getUrlPath();
    }

    private ContentEntityObject getContentEntityObject(RssRenderItem item) {
        return (ContentEntityObject)item.getEntity();
    }

    protected String getText(String key) {
        return ConfluenceActionSupport.getTextStatic(key);
    }

    public void setWikiStyleRenderer(WikiStyleRenderer wikiStyleRenderer) {
        this.wikiStyleRenderer = wikiStyleRenderer;
    }

    public void setSettingsManager(SettingsManager settingsManager) {
        this.settingsManager = settingsManager;
    }

    public void setUserAccessor(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }

    public void setWebResourceManager(WebResourceManager webResourceManager) {
        this.webResourceManager = webResourceManager;
    }

    protected Map getContextMap(RssRenderItem item) {
        Map contextMap = item.getDefaultVelocityContext();
        contextMap.put("baseurl", this.settingsManager.getGlobalSettings().getBaseUrl());
        contextMap.put("stylesheet", ConfluenceRenderUtils.renderDefaultStylesheet());
        contextMap.put("userAccessor", this.userAccessor);
        contextMap.put("wikiStyleRenderer", this.wikiStyleRenderer);
        contextMap.put("webResourceManager", this.webResourceManager);
        return contextMap;
    }
}

