/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rss;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.rss.AbstractContentEntityRenderSupport;
import com.atlassian.confluence.rss.RssRenderItem;
import com.atlassian.confluence.rss.RssRenderSupport;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.renderer.RenderContext;
import com.sun.syndication.feed.synd.SyndCategoryImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class AttachmentRenderSupport
extends AbstractContentEntityRenderSupport
implements RssRenderSupport {
    private AttachmentManager attachmentManager;

    private Attachment getAttachment(RssRenderItem item) {
        return (Attachment)item.getEntity();
    }

    public String getTitle(RssRenderItem item) {
        Attachment attachment = this.getAttachment(item);
        ContentEntityObject content = attachment.getContent();
        return content.getTitle() + " > " + attachment.getFileName();
    }

    public String getLink(RssRenderItem item) {
        return this.getAttachment(item).getDownloadPath();
    }

    public List getCategories(RssRenderItem item) {
        ArrayList<SyndCategoryImpl> categories = new ArrayList<SyndCategoryImpl>();
        Attachment attachment = this.getAttachment(item);
        for (Label label : attachment.getContent().getLabels()) {
            SyndCategoryImpl category = new SyndCategoryImpl();
            category.setName(label.getName());
            categories.add(category);
        }
        return categories;
    }

    public String getRenderedContent(RssRenderItem item) {
        Attachment attachment = this.getAttachment(item);
        ContentEntityObject content = attachment.getContent();
        List historyList = this.attachmentManager.getPreviousVersions(attachment);
        Map contextMap = this.getContextMap(item);
        contextMap.put("attachment", attachment);
        contextMap.put("page", attachment.getContent());
        contextMap.put("contentObject", content);
        contextMap.put("historyList", historyList);
        contextMap.put("content", this.wikiStyleRenderer.convertWikiToXHtml((RenderContext)content.toPageContext(), content.getContent()));
        return VelocityUtils.getRenderedTemplate("templates/rss/attachment-rss-content.vm", contextMap);
    }

    public void setAttachmentManager(AttachmentManager attachmentManager) {
        this.attachmentManager = attachmentManager;
    }
}

