/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.search;

import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.spaces.SpaceType;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.core.util.PairType;
import com.atlassian.user.User;
import com.opensymphony.xwork.ActionSupport;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpacePickerHelper {
    private SpaceManager spaceManager;
    private LabelManager labelManager;
    private static final int MAX_SPACE_NAME_LENGTH = 20;

    public SpacePickerHelper(SpaceManager spaceManager, LabelManager labelManager) {
        this.spaceManager = spaceManager;
        this.labelManager = labelManager;
    }

    public List getAvailableSpaces(User user) {
        ArrayList<PairType> availableSpaces = new ArrayList<PairType>();
        List allSpaces = this.spaceManager.getPermittedSpaces(user);
        if (user != null) {
            allSpaces.removeAll(this.labelManager.getFavouriteSpaces(user.getName()));
        }
        for (int i = 0; i < allSpaces.size(); ++i) {
            Space space = (Space)allSpaces.get(i);
            availableSpaces.add(new PairType((Serializable)((Object)space.getKey()), (Serializable)((Object)space.getName())));
        }
        return availableSpaces;
    }

    public List<PairType> getAvailableGlobalSpaces(User user) {
        ArrayList<PairType> availableSpaces = new ArrayList<PairType>();
        List globalSpaces = this.spaceManager.getPermittedSpacesByType(user, SpaceType.GLOBAL);
        if (user != null) {
            globalSpaces.removeAll(this.labelManager.getFavouriteSpaces(user.getName()));
        }
        for (int i = 0; i < globalSpaces.size(); ++i) {
            Space space = (Space)globalSpaces.get(i);
            availableSpaces.add(new PairType((Serializable)((Object)space.getKey()), (Serializable)((Object)GeneralUtil.shortenString(space.getName(), 20))));
        }
        return availableSpaces;
    }

    public List getAggregateOptions(ActionSupport action) {
        ArrayList<PairType> aggreateOptions = new ArrayList<PairType>();
        aggreateOptions.add(new PairType((Serializable)((Object)"conf_all"), (Serializable)((Object)action.getText("inspace.allspace"))));
        aggreateOptions.add(new PairType((Serializable)((Object)"conf_favorites"), (Serializable)((Object)action.getText("favourite.spaces"))));
        aggreateOptions.add(new PairType((Serializable)((Object)"conf_global"), (Serializable)((Object)action.getText("global.spaces"))));
        aggreateOptions.add(new PairType((Serializable)((Object)"conf_personal"), (Serializable)((Object)action.getText("personal.spaces"))));
        return aggreateOptions;
    }

    public List getFavouriteSpaces(User user) {
        ArrayList<PairType> availableSpaces = new ArrayList<PairType>();
        if (user != null) {
            List favSpaces = this.labelManager.getFavouriteSpaces(user.getName());
            for (int i = 0; i < favSpaces.size(); ++i) {
                Space space = (Space)favSpaces.get(i);
                availableSpaces.add(new PairType((Serializable)((Object)space.getKey()), (Serializable)((Object)GeneralUtil.shortenString(space.getName(), 20))));
            }
        }
        return availableSpaces;
    }
}

