/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.search.actions;

import bucket.core.actions.PaginationSupport;
import bucket.core.persistence.hibernate.HibernateHandle;
import com.atlassian.bonnie.AnyTypeObjectDao;
import com.atlassian.bonnie.Handle;
import com.atlassian.bonnie.Searcher;
import com.atlassian.confluence.search.actions.SearchResultWithExcerpt;
import com.atlassian.confluence.search.lucene.filter.ContentPermissionsFilter;
import com.atlassian.confluence.search.lucene.filter.FiltersContainer;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.user.User;
import com.atlassian.user.search.page.Pager;
import com.atlassian.util.profiling.UtilTimerStack;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Category;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;

public class SearchBean {
    private static Category log = Category.getInstance(SearchBean.class);
    private static Set DEFAULT_FIELD_SET = new HashSet();
    private Searcher searcher;
    private AnyTypeObjectDao anyTypeObjectDao;
    private PaginationSupport paginationSupport;
    private UserAccessor userAccessor;
    private int filteredCount;

    public SearchBean() {
        this.paginationSupport = new PaginationSupport();
    }

    public SearchBean(int maxResultsPerPage) {
        this.paginationSupport = new PaginationSupport(maxResultsPerPage);
    }

    public List search(Query query) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Searching: " + query.toString()));
        }
        return this.search(query, null);
    }

    public List search(Query query, Filter filter) {
        return this.search(query, filter, null);
    }

    public List search(Query query, Filter passedFilter, Sort sort) {
        UtilTimerStack.push((String)"SearchBean.search()");
        try {
            Map searchResult;
            int startIndex = this.paginationSupport.getStartIndexValue();
            if (startIndex < 0) {
                startIndex = 0;
            }
            int resultPerPage = this.paginationSupport.getCountOnEachPage();
            FiltersContainer filterContainer = this.createFilterContainer(passedFilter);
            int[] filteredCounts = new int[filterContainer.size()];
            Set fields = this.anyTypeObjectDao == null ? null : DEFAULT_FIELD_SET;
            List searchResults = this.searcher.searchForFields(query, fields, startIndex, Math.max(resultPerPage, resultPerPage * 2), (Filter)filterContainer, sort, filteredCounts);
            if (passedFilter != null) {
                this.filteredCount = filteredCounts[filterContainer.getFilters().indexOf(passedFilter)];
            }
            ListIterator<SearchResultWithExcerpt> it = searchResults.listIterator(startIndex);
            int i = startIndex;
            while (it.hasNext() && i < startIndex + resultPerPage && (searchResult = (Map)it.next()) != null) {
                if (this.anyTypeObjectDao != null) {
                    String handle = (String)searchResult.get("handle");
                    String content = (String)searchResult.get("contentBody");
                    Object resultObject = this.anyTypeObjectDao.findByHandle((Handle)new HibernateHandle(handle));
                    if (resultObject != null) {
                        SearchResultWithExcerpt srwe = new SearchResultWithExcerpt(content, resultObject);
                        it.set(srwe);
                        ++i;
                        continue;
                    }
                    it.remove();
                    continue;
                }
                SearchResultWithExcerpt srwe = new SearchResultWithExcerpt(searchResult);
                it.set(srwe);
                ++i;
            }
            this.setResults(searchResults);
        }
        catch (Throwable e) {
            this.setResults(Collections.EMPTY_LIST);
            log.error((Object)"Error while searching the site!", e);
        }
        UtilTimerStack.pop((String)"SearchBean.search()");
        return this.getPaginationSupport().getItems();
    }

    private FiltersContainer createFilterContainer(Filter filter) {
        FiltersContainer filters = new FiltersContainer();
        filters.addFilter(this.createContentPermissionFilter());
        if (filter != null) {
            filters.addFilter(filter);
        }
        return filters;
    }

    private ContentPermissionsFilter createContentPermissionFilter() {
        User user = AuthenticatedUserThreadLocal.getUser();
        Pager groups = user != null ? this.userAccessor.getGroups(user) : null;
        return new ContentPermissionsFilter(user, groups);
    }

    public void setResults(List results) {
        this.getPaginationSupport().setItems(results);
    }

    public void setSearcher(Searcher searcher) {
        this.searcher = searcher;
    }

    public void setAnyTypeObjectDao(AnyTypeObjectDao anyTypeObjectDao) {
        this.anyTypeObjectDao = anyTypeObjectDao;
    }

    public PaginationSupport getPaginationSupport() {
        return this.paginationSupport;
    }

    public void setPaginationSupport(PaginationSupport paginationSupport) {
        this.paginationSupport = paginationSupport;
    }

    public void setUserAccessor(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }

    public int getFilteredCount() {
        return this.filteredCount;
    }

    public int getExcludedGlobalResultsNum(Query query, Filter filter) {
        int totalHits = this.searcher.searchCount(query, (Filter)this.createFilterContainer(filter));
        return totalHits - this.getPaginationSupport().getTotal();
    }

    static {
        DEFAULT_FIELD_SET.add("handle");
        DEFAULT_FIELD_SET.add("contentBody");
    }
}

