/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.search.actions;

import com.atlassian.bonnie.LuceneUtils;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.user.User;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.builder.ToStringBuilder;

public class SearchResultWithExcerpt
implements Map {
    private final Map backingMap;
    private Object resultObject;
    private String contentBodyString;
    private UserAccessor userAccessor;

    public SearchResultWithExcerpt(ContentEntityObject ceo) {
        this.resultObject = ceo;
        this.backingMap = new HashMap();
    }

    public SearchResultWithExcerpt(String content, Object resultObject) throws ClassNotFoundException {
        this.resultObject = resultObject;
        this.contentBodyString = content;
        this.backingMap = new HashMap();
    }

    public SearchResultWithExcerpt(Map backing) {
        this.backingMap = backing;
        if (backing.containsKey("modified")) {
            backing.put("lastModificationDate", LuceneUtils.stringToDate((String)((String)backing.get("modified"))));
        }
        if (backing.containsKey("created")) {
            backing.put("creationDate", LuceneUtils.stringToDate((String)((String)backing.get("created"))));
        }
        if (backing.containsKey("title")) {
            backing.put("realTitle", backing.get("title"));
        }
    }

    public boolean isNew() {
        return this.get("created").equals(this.get("modified"));
    }

    public boolean isRecentlyUpdatedFor(User user) {
        Date lastLogin = this.getUserAccessor().getPropertySet(user).getDate("confluence.user.previous.login.date");
        if (lastLogin == null) {
            return false;
        }
        if (this.backingMap.containsKey("lastModificationDate")) {
            return lastLogin.before((Date)this.backingMap.get("lastModificationDate"));
        }
        if (this.backingMap.containsKey("creationDate")) {
            return lastLogin.before((Date)this.backingMap.get("creationDate"));
        }
        return false;
    }

    public UserAccessor getUserAccessor() {
        if (this.userAccessor == null) {
            this.userAccessor = (UserAccessor)ContainerManager.getComponent((String)"userAccessor");
        }
        return this.userAccessor;
    }

    public Object getResultObject() {
        return this.resultObject;
    }

    public String getContentBodyString() {
        return this.contentBodyString;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchResultWithExcerpt that = (SearchResultWithExcerpt)o;
        return this.resultObject.equals(that.resultObject);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("backingMap", (Object)this.backingMap).append("resultObject", this.resultObject).append("contentBodyString", (Object)this.contentBodyString).toString();
    }

    public int hashCode() {
        return this.resultObject.hashCode();
    }

    public int size() {
        return this.backingMap.size();
    }

    public void clear() {
        this.backingMap.clear();
    }

    public boolean isEmpty() {
        return this.backingMap.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.backingMap.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.backingMap.containsValue(value);
    }

    public Collection values() {
        return this.backingMap.values();
    }

    public void putAll(Map m) {
        this.backingMap.putAll(m);
    }

    public Set entrySet() {
        return this.backingMap.entrySet();
    }

    public Set keySet() {
        return this.backingMap.keySet();
    }

    public Object get(Object key) {
        return this.backingMap.get(key);
    }

    public Object remove(Object key) {
        return this.backingMap.remove(key);
    }

    public Object put(Object key, Object value) {
        return this.backingMap.put(key, value);
    }
}

