/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.search.lucene;

import com.atlassian.confluence.search.lucene.CustomJapaneseAnalyzer;
import com.atlassian.confluence.search.lucene.EnglishAnalyzer;
import com.atlassian.confluence.setup.settings.SettingsManager;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.SimpleAnalyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.br.BrazilianAnalyzer;
import org.apache.lucene.analysis.cjk.CJKAnalyzer;
import org.apache.lucene.analysis.cn.ChineseAnalyzer;
import org.apache.lucene.analysis.cz.CzechAnalyzer;
import org.apache.lucene.analysis.de.GermanAnalyzer;
import org.apache.lucene.analysis.el.GreekAnalyzer;
import org.apache.lucene.analysis.fr.FrenchAnalyzer;
import org.apache.lucene.analysis.ru.RussianAnalyzer;
import org.apache.lucene.analysis.ru.RussianCharsets;

public class ConfluenceAnalyzer
extends Analyzer {
    private SettingsManager settingsManager;
    public static final Map analyzers = new HashMap();
    public static final Analyzer SIMPLE_ANALYZER;

    public ConfluenceAnalyzer(SettingsManager settingsManager) {
        this.settingsManager = settingsManager;
    }

    public final TokenStream tokenStream(String fieldname, Reader reader) {
        String indexingLanguage = this.settingsManager.getGlobalSettings().getIndexingLanguage();
        if (analyzers.containsKey(indexingLanguage)) {
            Analyzer analyzer = (Analyzer)analyzers.get(indexingLanguage);
            if (analyzer instanceof FrenchAnalyzer && fieldname == null) {
                return analyzer.tokenStream("", reader);
            }
            return analyzer.tokenStream(fieldname, reader);
        }
        return SIMPLE_ANALYZER.tokenStream(fieldname, reader);
    }

    static {
        analyzers.put("english", new EnglishAnalyzer());
        analyzers.put("russian", new RussianAnalyzer(RussianCharsets.UnicodeRussian));
        analyzers.put("german", new GermanAnalyzer());
        analyzers.put("chinese", new ChineseAnalyzer());
        analyzers.put("CJK", new CJKAnalyzer());
        analyzers.put("CJK", new CustomJapaneseAnalyzer());
        analyzers.put("french", new FrenchAnalyzer());
        analyzers.put("brazilian", new BrazilianAnalyzer());
        analyzers.put("czech", new CzechAnalyzer());
        analyzers.put("greek", new GreekAnalyzer());
        SIMPLE_ANALYZER = new SimpleAnalyzer();
    }
}

