/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.search.lucene;

import com.atlassian.bonnie.AnyTypeObjectDao;
import com.atlassian.bonnie.Handle;
import com.atlassian.bonnie.Searchable;
import com.atlassian.bonnie.search.BaseDocumentBuilder;
import com.atlassian.bonnie.search.DocumentBuilder;
import com.atlassian.bonnie.search.DocumentPostProcessor;
import com.atlassian.confluence.plugin.descriptor.ExtractorModuleDescriptor;
import com.atlassian.confluence.search.lucene.postprocessor.ContentBoostPostProcessor;
import com.atlassian.plugin.PluginAccessor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.apache.lucene.document.Document;

public class ConfluenceDocumentBuilder
implements DocumentBuilder {
    private PluginAccessor pluginAccessor;
    private AnyTypeObjectDao anyTypeObjectDao;
    private DocumentBuilder documentBuilder;
    private List<DocumentPostProcessor> postProcessors;

    public ConfluenceDocumentBuilder(AnyTypeObjectDao anyTypeObjectDao, PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
        this.anyTypeObjectDao = anyTypeObjectDao;
        this.postProcessors = new ArrayList<DocumentPostProcessor>(1);
        this.postProcessors.add(new ContentBoostPostProcessor());
    }

    void resetDocumentBuilder() {
        this.documentBuilder = null;
    }

    private DocumentBuilder getDocumentBuilder() {
        if (this.documentBuilder == null) {
            this.documentBuilder = new BaseDocumentBuilder(this.anyTypeObjectDao, this.getExtractors(), this.postProcessors);
        }
        return this.documentBuilder;
    }

    private List getExtractors() {
        List extractors = this.pluginAccessor.getEnabledModuleDescriptorsByClass(ExtractorModuleDescriptor.class);
        ArrayList orderedExtractors = new ArrayList(extractors);
        Collections.sort(orderedExtractors);
        ListIterator<Object> iterator = orderedExtractors.listIterator();
        while (iterator.hasNext()) {
            ExtractorModuleDescriptor module = (ExtractorModuleDescriptor)iterator.next();
            iterator.set(module.getModule());
        }
        return orderedExtractors;
    }

    public Document getDocument(Searchable searchable) {
        return this.getDocumentBuilder().getDocument(searchable);
    }

    public Handle getHandle(Object obj) {
        return this.getDocumentBuilder().getHandle(obj);
    }
}

