/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.search.lucene;

import com.atlassian.bonnie.analyzer.LuceneAnalyzerFactory;
import com.atlassian.confluence.search.lucene.ConfluenceAnalyzer;
import com.atlassian.confluence.search.lucene.ConfluenceFilenameAnalyzer;
import com.atlassian.confluence.search.lucene.analyzers.PersonalInformationLeadingNGramAnalyzer;
import com.atlassian.confluence.search.lucene.analyzers.PersonalInformationNGramAnalyzer;
import com.atlassian.confluence.setup.settings.SettingsManager;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.KeywordAnalyzer;
import org.apache.lucene.analysis.PerFieldAnalyzerWrapper;

public class ConfluenceLuceneAnalyzerFactory
implements LuceneAnalyzerFactory {
    private SettingsManager settingsManager;
    private Analyzer indexingAnalyzer;
    private Analyzer searchingAnalyzer;
    private static List KEYWORD_FIELDS = Arrays.asList("handle", "classname", "spacekey", "urlPath", "type", "space.type", "attachmentContentType");
    private static final PersonalInformationLeadingNGramAnalyzer LEADING_NGRAM_ANALYZER = new PersonalInformationLeadingNGramAnalyzer();
    private static final PersonalInformationNGramAnalyzer NGRAM_ANALYZER = new PersonalInformationNGramAnalyzer();

    public Analyzer createIndexingAnalyzer() {
        if (this.indexingAnalyzer == null) {
            ConfluenceAnalyzer confluenceAnalyzer = new ConfluenceAnalyzer(this.settingsManager);
            PerFieldAnalyzerWrapper analyzer = new PerFieldAnalyzerWrapper((Analyzer)confluenceAnalyzer);
            analyzer.addAnalyzer("filename", (Analyzer)new ConfluenceFilenameAnalyzer(confluenceAnalyzer));
            analyzer.addAnalyzer("personal-info-start-ngrams", (Analyzer)LEADING_NGRAM_ANALYZER);
            analyzer.addAnalyzer("personal-info-ngrams", (Analyzer)NGRAM_ANALYZER);
            this.indexingAnalyzer = analyzer;
        }
        return this.indexingAnalyzer;
    }

    public Analyzer createAnalyzer() {
        if (this.searchingAnalyzer == null) {
            this.searchingAnalyzer = new PerFieldAnalyzerWrapper((Analyzer)new ConfluenceAnalyzer(this.settingsManager));
            for (String fieldName : KEYWORD_FIELDS) {
                PerFieldAnalyzerWrapper perFieldAnalyzer = (PerFieldAnalyzerWrapper)this.searchingAnalyzer;
                perFieldAnalyzer.addAnalyzer(fieldName, (Analyzer)new KeywordAnalyzer());
                perFieldAnalyzer.addAnalyzer("personal-info-start-ngrams", (Analyzer)LEADING_NGRAM_ANALYZER);
                perFieldAnalyzer.addAnalyzer("personal-info-ngrams", (Analyzer)NGRAM_ANALYZER);
            }
        }
        return this.searchingAnalyzer;
    }

    public void setSettingsManager(SettingsManager settingsManager) {
        this.settingsManager = settingsManager;
    }
}

