/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.search.lucene;

import com.atlassian.confluence.security.ContentPermission;
import com.atlassian.confluence.security.ContentPermissionSet;
import java.util.Iterator;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Category;

public class ContentPermissionSearchUtils {
    public static final Category log = Category.getInstance(ContentPermissionSearchUtils.class);
    public static final String ESCAPE_CHAR = "#";
    private static final Pattern HASH_PATTERN = Pattern.compile("\\#");
    private static final Pattern PIPE_PATTERN = Pattern.compile("\\|");
    private static final Pattern AMPERSAND_PATTERN = Pattern.compile("\\&");
    private static final String ESCAPED_HASH = "#h";
    private static final String ESCAPED_PIPE = "#p";
    private static final String ESCAPED_AMPERSAND = "#a";
    private static final String GROUP_PREFIX = "g";
    private static final String USER_PREFIX = "u";

    public static String getEncodedContentPermissionSet(ContentPermissionSet contentPermissionSet) {
        if (contentPermissionSet == null) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        Iterator iterator = contentPermissionSet.iterator();
        while (iterator.hasNext()) {
            ContentPermission perm = (ContentPermission)iterator.next();
            result.append(ContentPermissionSearchUtils.getEncodedContentPermission(perm));
            if (!iterator.hasNext()) continue;
            result.append("|");
        }
        return result.toString();
    }

    static String getEncodedContentPermission(ContentPermission perm) {
        if (perm == null) {
            return null;
        }
        String result = "";
        if (perm.isUserPermission()) {
            result = ContentPermissionSearchUtils.getEncodedUserName(perm.getUserName());
        } else if (perm.isGroupPermission()) {
            result = ContentPermissionSearchUtils.getEncodedGroupName(perm.getGroupName());
        } else {
            log.error((Object)("Skipping invalid content permission: " + perm));
        }
        return result;
    }

    static String escapeEntityName(String entityName) {
        entityName = HASH_PATTERN.matcher(entityName).replaceAll(ESCAPED_HASH);
        entityName = PIPE_PATTERN.matcher(entityName).replaceAll(ESCAPED_PIPE);
        entityName = AMPERSAND_PATTERN.matcher(entityName).replaceAll(ESCAPED_AMPERSAND);
        return entityName;
    }

    public static String getEncodedUserName(String username) {
        if (StringUtils.isEmpty((String)username)) {
            return username;
        }
        return USER_PREFIX + ContentPermissionSearchUtils.escapeEntityName(username);
    }

    public static String getEncodedGroupName(String groupname) {
        if (StringUtils.isEmpty((String)groupname)) {
            return groupname;
        }
        return GROUP_PREFIX + ContentPermissionSearchUtils.escapeEntityName(groupname);
    }
}

