/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.search.lucene;

import com.atlassian.bonnie.Handle;
import com.atlassian.bonnie.ILuceneConnection;
import com.atlassian.confluence.search.IndexingTask;
import com.atlassian.confluence.search.lucene.ConfluenceBatchIndexer;
import com.atlassian.confluence.search.lucene.ConfluenceIndexManager;
import com.atlassian.confluence.search.lucene.ConfluenceLuceneConnection;
import com.atlassian.confluence.search.lucene.ContentIndexTask;
import com.atlassian.confluence.search.lucene.FlushStatistics;
import com.atlassian.confluence.search.lucene.IndexTask;
import com.atlassian.confluence.search.lucene.IndexTaskQueue;
import com.atlassian.confluence.search.lucene.bonnie.BulkReaderAction;
import com.atlassian.confluence.search.lucene.bonnie.BulkWriterAction;
import com.atlassian.confluence.search.lucene.tasks.IndexTaskFactory;
import com.atlassian.confluence.search.lucene.tasks.OptimizeIndexTask;
import com.atlassian.confluence.search.lucene.tasks.UpdateDocumentIndexTask;
import com.atlassian.spring.container.ContainerManager;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Category;
import org.apache.lucene.index.IndexReader;

public class DefaultConfluenceIndexManager
implements ConfluenceIndexManager {
    public static final Category log = Category.getInstance(DefaultConfluenceIndexManager.class);
    private IndexTaskQueue taskQueue;
    private ConfluenceLuceneConnection luceneConnection;
    private IndexingTask reindexTask;
    private volatile boolean flushing = false;
    private FlushStatistics stats;
    private final Object lock = new Object();
    private IndexTaskFactory indexTaskFactory;
    private static final String REINDEXING_THREAD_NAME = "confluence-interactive-reindexing-thread";

    public boolean isFlushing() {
        return this.flushing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushQueue() {
        if (this.isReIndexing()) {
            return;
        }
        FlushStatistics currentFlushStats = new FlushStatistics();
        Object object = this.lock;
        synchronized (object) {
            while (this.isFlushing()) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException e) {
                    log.warn((Object)(this.toString() + " queue interrupted while waiting for previous flush to finish. " + e.getMessage()));
                }
            }
            this.flushing = true;
            currentFlushStats.setStarted(new Date());
        }
        try {
            List tasksToProcess = this.taskQueue.flushQueue();
            if (tasksToProcess.size() > 0) {
                currentFlushStats.setQueueSize(tasksToProcess.size());
                currentFlushStats.setOptimised(false);
                currentFlushStats.setRecreated(false);
                this.processTasks(tasksToProcess, currentFlushStats);
                currentFlushStats.setFinished(new Date());
                this.stats = currentFlushStats;
            }
        }
        finally {
            object = this.lock;
            synchronized (object) {
                this.flushing = false;
                this.lock.notifyAll();
            }
        }
    }

    public void resetIndexQueue() {
        this.taskQueue.reset();
    }

    private void processTasks(List entries, FlushStatistics flushStatistics) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Found index queue entries:" + entries));
        }
        ArrayList<IndexTask> deleteEntries = new ArrayList<IndexTask>(entries.size());
        ArrayList<IndexTask> addEntries = new ArrayList<IndexTask>(entries.size());
        for (IndexTask task : entries) {
            if (task instanceof UpdateDocumentIndexTask) {
                UpdateDocumentIndexTask updateTask = (UpdateDocumentIndexTask)task;
                this.clearMatchingTasks(addEntries, updateTask.getHandle());
                this.clearMatchingTasks(deleteEntries, updateTask.getHandle());
                try {
                    deleteEntries.add(updateTask.getDeleteTask(this.indexTaskFactory));
                    addEntries.add(updateTask.getAddTask(this.indexTaskFactory));
                }
                catch (ParseException e1) {
                    log.warn((Object)("Could not create tasks for handle: " + updateTask.getHandle().toString()), (Throwable)e1);
                }
                continue;
            }
            if (task instanceof ILuceneConnection.WriterAction) {
                if (task instanceof ContentIndexTask) {
                    this.clearMatchingTasks(addEntries, ((ContentIndexTask)task).getHandle());
                }
                if (task instanceof OptimizeIndexTask) {
                    flushStatistics.setOptimised(true);
                }
                addEntries.add(task);
            }
            if (!(task instanceof ILuceneConnection.ReaderAction)) continue;
            if (task instanceof ContentIndexTask) {
                Handle handle = ((ContentIndexTask)task).getHandle();
                this.clearMatchingTasks(addEntries, handle);
                this.clearMatchingTasks(deleteEntries, handle);
            }
            deleteEntries.add(task);
        }
        if (deleteEntries.size() > 0) {
            this.luceneConnection.withReaderAndDeletes(new BulkReaderAction(deleteEntries));
        }
        if (addEntries.size() > 0) {
            this.luceneConnection.withWriter(new BulkWriterAction(addEntries));
        }
        try {
            if (!this.luceneConnection.isSearcherCurrent()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Refreshing searcher");
                }
                this.luceneConnection.refreshSearcher();
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"Not refreshing searcher - searcher is still current");
            }
        }
        catch (IOException e) {
            log.error((Object)"Failed to refresh the lucene searcher.", (Throwable)e);
        }
    }

    public void optimizeIndex() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enqueue Optimize Index Task");
        }
        this.taskQueue.enqueue(new OptimizeIndexTask());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reIndex() {
        try {
            this.waitUntil(new NotFlushing(), 5000L);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Can not reindex whilst flushing is in progress.");
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.isReIndexing()) {
                return;
            }
            ConfluenceBatchIndexer springWrappedThis = (ConfluenceBatchIndexer)ContainerManager.getComponent((String)"confluenceBatchIndexer");
            this.reindexTask = new IndexingTask(springWrappedThis);
            Thread reindexingThread = new Thread((Runnable)((Object)this.reindexTask));
            reindexingThread.setName(REINDEXING_THREAD_NAME);
            reindexingThread.start();
        }
    }

    public boolean isReIndexing() {
        return this.getLastReindexingTask() != null && !this.getLastReindexingTask().isFinishedReindexing();
    }

    public IndexingTask getLastReindexingTask() {
        return this.reindexTask;
    }

    public void unIndexAll() {
        try {
            this.waitUntil(new NotFlushingOrReindexing(), 10000L);
        }
        catch (InterruptedException e) {
            log.error((Object)"", (Throwable)e);
        }
        this.luceneConnection.withReaderAndDeletes(new ILuceneConnection.ReaderAction(){

            public Object perform(IndexReader indexReader) throws IOException {
                int max = indexReader.maxDoc();
                for (int i = 0; i < max; ++i) {
                    indexReader.deleteDocument(i);
                }
                return null;
            }
        });
    }

    public IndexTaskQueue getTaskQueue() {
        return this.taskQueue;
    }

    public FlushStatistics getLastNonEmptyFlushStats() {
        return this.stats;
    }

    private void waitUntil(Condition con, long timeout) throws InterruptedException {
        boolean checkFailed;
        long startTime = System.currentTimeMillis();
        while ((checkFailed = !con.check()) && System.currentTimeMillis() - startTime < timeout) {
            Thread.yield();
        }
        if (checkFailed) {
            throw new InterruptedException();
        }
    }

    public void setIndexTaskFactory(IndexTaskFactory indexTaskFactory) {
        this.indexTaskFactory = indexTaskFactory;
    }

    public void setTaskQueue(IndexTaskQueue taskQueue) {
        this.taskQueue = taskQueue;
    }

    public void setLuceneConnection(ConfluenceLuceneConnection luceneConnection) {
        this.luceneConnection = luceneConnection;
    }

    private void clearMatchingTasks(List tasks, Handle handle) {
        Iterator it = tasks.iterator();
        while (it.hasNext()) {
            ContentIndexTask contentIndexTask;
            IndexTask indexTask = (IndexTask)it.next();
            if (!(indexTask instanceof ContentIndexTask) || !(contentIndexTask = (ContentIndexTask)indexTask).getHandle().equals(handle)) continue;
            it.remove();
        }
    }

    private class NotFlushing
    implements Condition {
        private NotFlushing() {
        }

        public boolean check() {
            return !DefaultConfluenceIndexManager.this.isFlushing();
        }
    }

    private class NotFlushingOrReindexing
    implements Condition {
        private NotFlushingOrReindexing() {
        }

        public boolean check() {
            return !DefaultConfluenceIndexManager.this.isFlushing() && !DefaultConfluenceIndexManager.this.isReIndexing();
        }
    }

    private static interface Condition {
        public boolean check();
    }
}

