/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.search.lucene;

import com.atlassian.bonnie.Searchable;
import com.atlassian.confluence.search.ConfluenceIndexer;
import com.atlassian.confluence.search.lucene.IndexTaskQueue;
import com.atlassian.confluence.search.lucene.tasks.IndexTaskFactory;
import com.atlassian.confluence.spaces.Space;
import org.apache.log4j.Category;

public class QueuingConfluenceIndexer
implements ConfluenceIndexer {
    public static final Category LOG = Category.getInstance(QueuingConfluenceIndexer.class);
    private static ThreadLocal threadLocal = new ThreadLocal();
    private IndexTaskQueue taskQueue;
    private IndexTaskFactory indexTaskFactory;

    public void unIndexSpace(Space space) {
        if (QueuingConfluenceIndexer.shouldIndex()) {
            this.taskQueue.enqueue(this.indexTaskFactory.createUnIndexSpaceTask(space));
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Not queueing unindex space task: " + space));
        }
    }

    public void unIndexIncludingDependents(Searchable searchable) {
        if (!QueuingConfluenceIndexer.shouldIndex()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Not queuing unindex with dependents: " + searchable));
            }
            return;
        }
        for (Searchable dependent : searchable.getSearchableDependants()) {
            this.unIndex(dependent);
        }
        this.unIndex(searchable);
    }

    public void unIndex(Searchable searchable) {
        if (QueuingConfluenceIndexer.shouldIndex()) {
            this.taskQueue.enqueue(this.indexTaskFactory.createDeleteDocumentTask(searchable));
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Not queuing unindex: " + searchable));
        }
    }

    public void reIndex(Searchable searchable) {
        if (QueuingConfluenceIndexer.shouldIndex() && searchable.isIndexable()) {
            this.taskQueue.enqueue(this.indexTaskFactory.createUpdateDocumentTask(searchable));
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Not queuing reindex: " + searchable));
        }
    }

    public void indexIncludingDependents(Searchable searchable) {
        if (!QueuingConfluenceIndexer.shouldIndex()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Not queuing index with dependents: " + searchable));
            }
            return;
        }
        for (Searchable dependent : searchable.getSearchableDependants()) {
            this.index(dependent);
        }
        this.index(searchable);
    }

    public void index(Searchable searchable) {
        if (QueuingConfluenceIndexer.shouldIndex() && searchable.isIndexable()) {
            this.taskQueue.enqueue(this.indexTaskFactory.createAddDocumentTask(searchable));
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Not queuing index: " + searchable));
        }
    }

    public void setTaskQueue(IndexTaskQueue taskQueue) {
        this.taskQueue = taskQueue;
    }

    public static void suspendIndexing() {
        threadLocal.set(Boolean.TRUE);
    }

    public static void resumeIndexing() {
        threadLocal.set(Boolean.FALSE);
    }

    public static boolean shouldIndex() {
        return !Boolean.TRUE.equals(threadLocal.get());
    }

    public void setIndexTaskFactory(IndexTaskFactory indexTaskFactory) {
        this.indexTaskFactory = indexTaskFactory;
    }
}

