/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.search.lucene.extractor;

import com.atlassian.bonnie.Searchable;
import com.atlassian.bonnie.search.Extractor;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.SpaceContentEntityObject;
import com.atlassian.confluence.pages.Attachment;
import net.sf.hibernate.Hibernate;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;

public class AttachmentSpaceExtractor
implements Extractor {
    public static final String FIELD_ATTACHMENT_CONTENT_TYPE = "attachmentContentType";

    public void addFields(Document document, StringBuffer defaultContent, Searchable searchable) {
        if (searchable instanceof Attachment) {
            ContentEntityObject content = ((Attachment)searchable).getContent();
            if (content instanceof SpaceContentEntityObject) {
                this.addSpaceField((SpaceContentEntityObject)content, document);
            }
            this.addAttachmentContentTypeField(content, document);
        }
    }

    private void addAttachmentContentTypeField(ContentEntityObject content, Document document) {
        if (content == null) {
            return;
        }
        Field attachmentContentType = new Field(FIELD_ATTACHMENT_CONTENT_TYPE, Hibernate.getClass((Object)content).getName(), Field.Store.YES, Field.Index.UN_TOKENIZED);
        document.add((Fieldable)attachmentContentType);
    }

    private void addSpaceField(SpaceContentEntityObject spaceContent, Document document) {
        String spaceKey = spaceContent.getSpace().getKey();
        String spaceType = spaceContent.getSpace().getSpaceType().toString();
        document.add((Fieldable)new Field("spacekey", spaceKey, Field.Store.YES, Field.Index.UN_TOKENIZED));
        document.add((Fieldable)new Field("space.type", spaceType, Field.Store.YES, Field.Index.UN_TOKENIZED));
    }
}

