/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.search.lucene.extractor;

import com.atlassian.bonnie.Searchable;
import com.atlassian.bonnie.search.Extractor;
import com.atlassian.confluence.core.ConfluenceEntityObject;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.VersionHistorySummary;
import com.atlassian.confluence.core.persistence.ContentEntityObjectDao;
import com.opensymphony.util.TextUtils;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;

public class ContentEntityMetadataExtractor
implements Extractor {
    public static final String CREATOR_NAME_FIELD = "creatorName";
    public static final String LAST_MODIFIER_NAME_FIELD = "lastModifierName";
    public static final String LAST_MODIFIERS_FIELD = "lastModifiers";
    private ContentEntityObjectDao contentEntityObjectDao;

    public void addFields(Document document, StringBuffer defaultSearchableText, Searchable searchable) {
        if (searchable instanceof ConfluenceEntityObject) {
            this.extractCreatorAndModifier((ConfluenceEntityObject)searchable, document);
        }
        if (searchable instanceof ContentEntityObject) {
            this.addFieldsToContentBody((ContentEntityObject)searchable, defaultSearchableText);
            this.extractExcerpt((ContentEntityObject)searchable, document);
        }
    }

    private void addFieldsToContentBody(ContentEntityObject contentEntityObject, StringBuffer searchableText) {
        StringBuffer extraBodyStuff = new StringBuffer();
        if (TextUtils.stringSet((String)contentEntityObject.getTitle())) {
            extraBodyStuff.append(contentEntityObject.getTitle()).append(" ");
        }
        searchableText.insert(0, extraBodyStuff.toString());
    }

    private void extractExcerpt(ContentEntityObject ceo, Document document) {
        String excerpt = ceo.getExcerpt();
        if (excerpt != null) {
            document.add((Fieldable)new Field("excerpt", excerpt, Field.Store.YES, Field.Index.NO));
        }
    }

    private void extractCreatorAndModifier(ConfluenceEntityObject ceo, Document document) {
        List versionHistories;
        if (ceo.getCreatorName() != null) {
            document.add((Fieldable)new Field(CREATOR_NAME_FIELD, ceo.getCreatorName(), Field.Store.YES, Field.Index.UN_TOKENIZED));
        }
        if ((versionHistories = this.contentEntityObjectDao.getVersionHistorySummary(ceo.getId())) != null) {
            HashSet<String> editors = new HashSet<String>();
            for (VersionHistorySummary summary : versionHistories) {
                String lastModifierName = summary.getLastModifierName();
                if (editors.contains(lastModifierName) || !StringUtils.isNotBlank((String)lastModifierName)) continue;
                document.add((Fieldable)new Field(LAST_MODIFIERS_FIELD, lastModifierName, Field.Store.YES, Field.Index.UN_TOKENIZED));
                editors.add(lastModifierName);
            }
        }
        if (ceo.getLastModifierName() != null) {
            document.add((Fieldable)new Field(LAST_MODIFIER_NAME_FIELD, ceo.getLastModifierName(), Field.Store.YES, Field.Index.NO));
        }
    }

    public void setContentEntityObjectDao(ContentEntityObjectDao contentDao) {
        this.contentEntityObjectDao = contentDao;
    }
}

