/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.search.lucene.extractor;

import com.atlassian.bonnie.LuceneUtils;
import com.atlassian.bonnie.Searchable;
import com.atlassian.bonnie.search.Extractor;
import com.atlassian.confluence.user.PersonalInformation;
import java.util.Date;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;

public class PersonalInformationExtractor
implements Extractor {
    public static final String IN_SPACE_FIELD = "inSpace";
    public static final String PERSONAL_INFO_START_NGRAMS_FIELD = "personal-info-start-ngrams";
    public static final String PERSONAL_INFO_NGRAMS_FIELD = "personal-info-ngrams";

    public void addFields(Document document, StringBuffer defaultSearchableText, Searchable searchable) {
        if (searchable instanceof PersonalInformation) {
            PersonalInformation pi = (PersonalInformation)searchable;
            if (pi.getCreationDate() != null && pi.getCreationDate().equals(pi.getLastModificationDate())) {
                if (document.getField("modified") != null) {
                    document.removeField("modified");
                }
                document.add((Fieldable)new Field("modified", LuceneUtils.dateToString((Date)new Date(0L)), Field.Store.YES, Field.Index.UN_TOKENIZED));
            }
            String aggregatedPersonalInfo = pi.getUsername() + " " + pi.getFullName();
            document.add((Fieldable)new Field(PERSONAL_INFO_START_NGRAMS_FIELD, aggregatedPersonalInfo, Field.Store.NO, Field.Index.TOKENIZED));
            document.add((Fieldable)new Field(PERSONAL_INFO_NGRAMS_FIELD, aggregatedPersonalInfo, Field.Store.NO, Field.Index.TOKENIZED));
            document.add((Fieldable)new Field(IN_SPACE_FIELD, "false", Field.Store.NO, Field.Index.UN_TOKENIZED));
        }
    }
}

