/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.search.lucene.extractor;

import com.atlassian.bonnie.Searchable;
import com.atlassian.bonnie.search.Extractor;
import com.atlassian.confluence.spaces.SpaceDescription;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.user.User;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;

public class SpaceDescriptionUsernameExtractor
implements Extractor {
    public void addFields(Document document, StringBuffer defaultSearchableText, Searchable searchable) {
        if (searchable instanceof SpaceDescription) {
            String username = ((SpaceDescription)searchable).getSpace().getCreatorName();
            UserAccessor ua = (UserAccessor)ContainerManager.getInstance().getContainerContext().getComponent((Object)"userAccessor");
            User user = ua.getUser(username);
            if (user != null) {
                document.add((Fieldable)new Field("username", username, Field.Store.YES, Field.Index.TOKENIZED));
                if (user.getEmail() != null) {
                    document.add((Fieldable)new Field("email", user.getEmail(), Field.Store.YES, Field.Index.TOKENIZED));
                }
                if (user.getFullName() != null) {
                    document.add((Fieldable)new Field("fullName", user.getFullName(), Field.Store.YES, Field.Index.TOKENIZED));
                    document.add((Fieldable)new Field("fullNameSortable", user.getFullName(), Field.Store.YES, Field.Index.UN_TOKENIZED));
                }
            }
        }
    }
}

