/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.search.lucene.filter;

import java.io.IOException;
import java.util.BitSet;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Filter;

public class ChainedFilter
extends Filter {
    public static final int OR = 0;
    public static final int AND = 1;
    public static final int ANDNOT = 2;
    public static final int XOR = 3;
    public static int DEFAULT = 0;
    private Filter[] chain = null;
    private int[] logicArray;
    private int logic = -1;

    public ChainedFilter(Filter[] chain) {
        this.chain = chain;
    }

    public ChainedFilter(Filter[] chain, int[] logicArray) {
        this.chain = chain;
        this.logicArray = logicArray;
    }

    public ChainedFilter(Filter[] chain, int logic) {
        this.chain = chain;
        this.logic = logic;
    }

    public BitSet bits(IndexReader reader) throws IOException {
        if (this.logic != -1) {
            return this.bits(reader, this.logic);
        }
        if (this.logicArray != null) {
            return this.bits(reader, this.logicArray);
        }
        return this.bits(reader, DEFAULT);
    }

    private BitSet bits(IndexReader reader, int logic) throws IOException {
        BitSet result;
        int i = 0;
        if (logic == 1) {
            result = (BitSet)this.chain[i].bits(reader).clone();
            ++i;
        } else {
            result = new BitSet(reader.maxDoc());
        }
        while (i < this.chain.length) {
            this.doChain(result, reader, logic, this.chain[i]);
            ++i;
        }
        return result;
    }

    private BitSet bits(IndexReader reader, int[] logic) throws IOException {
        BitSet result;
        if (logic.length != this.chain.length) {
            throw new IllegalArgumentException("Invalid number of elements in logic array");
        }
        int i = 0;
        if (logic[0] == 1) {
            result = (BitSet)this.chain[i].bits(reader).clone();
            ++i;
        } else {
            result = new BitSet(reader.maxDoc());
        }
        while (i < this.chain.length) {
            this.doChain(result, reader, logic[i], this.chain[i]);
            ++i;
        }
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("ChainedFilter: [");
        for (int i = 0; i < this.chain.length; ++i) {
            sb.append(this.chain[i]);
            sb.append(' ');
        }
        sb.append(']');
        return sb.toString();
    }

    private void doChain(BitSet result, IndexReader reader, int logic, Filter filter) throws IOException {
        switch (logic) {
            case 0: {
                result.or(filter.bits(reader));
                break;
            }
            case 1: {
                result.and(filter.bits(reader));
                break;
            }
            case 2: {
                result.andNot(filter.bits(reader));
                break;
            }
            case 3: {
                result.xor(filter.bits(reader));
                break;
            }
            default: {
                this.doChain(result, reader, DEFAULT, filter);
            }
        }
    }
}

