/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.search.lucene.filter;

import java.io.IOException;
import java.util.LinkedList;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;

public class ConfluenceNGramTokenFilter
extends TokenFilter {
    public static final int DEFAULT_MIN_NGRAM_SIZE = 1;
    public static final int DEFAULT_MAX_NGRAM_SIZE = 2;
    private int minGram;
    private int maxGram;
    private LinkedList<Token> ngrams;
    private Callback callback;
    public static Callback EXCLUDE_START_GRAMS = new Callback(){

        public boolean keepToken(int pos, Token token) {
            return pos != 0;
        }
    };
    public static Callback ALL_GRAMS = new Callback(){

        public boolean keepToken(int pos, Token token) {
            return true;
        }
    };
    public static Callback ONLY_START_GRAMS = new Callback(){

        public boolean keepToken(int pos, Token token) {
            return pos == 0;
        }
    };

    public ConfluenceNGramTokenFilter(TokenStream input, int minGram, int maxGram, Callback callback) {
        super(input);
        if (minGram < 1) {
            throw new IllegalArgumentException("minGram must be greater than zero");
        }
        if (minGram > maxGram) {
            throw new IllegalArgumentException("minGram must not be greater than maxGram");
        }
        this.minGram = minGram;
        this.maxGram = maxGram;
        this.ngrams = new LinkedList();
        this.callback = callback;
    }

    public ConfluenceNGramTokenFilter(TokenStream input, Callback callback) {
        this(input, 1, 2, callback);
    }

    public final Token next() throws IOException {
        if (this.ngrams.size() > 0) {
            return this.ngrams.removeFirst();
        }
        Token token = this.input.next();
        if (token == null) {
            return null;
        }
        this.ngram(token);
        if (this.ngrams.size() > 0) {
            return this.ngrams.removeFirst();
        }
        return null;
    }

    private void ngram(Token token) {
        String inStr = token.termText();
        int inLen = inStr.length();
        for (int gramSize = this.minGram; gramSize <= this.maxGram; ++gramSize) {
            int pos = 0;
            while (pos + gramSize <= inLen) {
                String gram = inStr.substring(pos, pos + gramSize);
                Token ngramToken = new Token(gram, pos, pos + gramSize);
                if (this.callback.keepToken(pos, ngramToken)) {
                    this.ngrams.add(ngramToken);
                }
                ++pos;
            }
        }
    }

    public static interface Callback {
        public boolean keepToken(int var1, Token var2);
    }
}

