/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.search.lucene.filter;

import com.atlassian.confluence.search.lucene.ContentPermissionSearchUtils;
import com.atlassian.user.Group;
import com.atlassian.user.User;
import com.atlassian.user.search.page.Pager;
import com.atlassian.util.profiling.UtilTimerStack;
import com.opensymphony.util.TextUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Category;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.search.Filter;

public class ContentPermissionsFilter
extends Filter {
    public static final Category log = Category.getInstance(ContentPermissionsFilter.class);
    private List userCredentials;
    private static final int BUFFER_SIZE = 128;

    public ContentPermissionsFilter(User user, Pager groups) {
        ArrayList<String> userCredentials = new ArrayList<String>();
        if (user != null) {
            userCredentials.add(ContentPermissionSearchUtils.getEncodedUserName(user.getName()));
        }
        if (groups != null) {
            for (Group group : groups) {
                if (group == null) {
                    log.error((Object)"Null group found. Skipping.");
                    continue;
                }
                userCredentials.add(ContentPermissionSearchUtils.getEncodedGroupName(group.getName()));
            }
        }
        this.userCredentials = userCredentials;
    }

    public BitSet bits(IndexReader reader) throws IOException {
        UtilTimerStack.push((String)"ContentPermissionFilter.bits");
        BitSet result = this.getPermittedDocs(reader);
        UtilTimerStack.pop((String)"ContentPermissionFilter.bits");
        return result;
    }

    private BitSet getPermittedDocs(IndexReader reader) throws IOException {
        Term term;
        BitSet result = new BitSet(reader.maxDoc());
        result.flip(0, reader.maxDoc());
        TermEnum termEnum = reader.terms(new Term("permissionSets", "a"));
        while ((term = termEnum.term()) != null && "permissionSets".equals(term.field())) {
            if (!this.checkEncodedCredentialSets(term.text())) {
                int[] freqs;
                int[] docs;
                int pointerMax;
                TermDocs termDocs = reader.termDocs(term);
                while ((pointerMax = termDocs.read(docs = new int[128], freqs = new int[128])) != 0) {
                    for (int i = 0; i < pointerMax; ++i) {
                        result.set(docs[i], false);
                    }
                }
            }
            if (termEnum.next()) continue;
        }
        return result;
    }

    private boolean checkEncodedCredentialSets(String encodedCredentials) {
        if (this.userCredentials.isEmpty()) {
            return false;
        }
        List credentialSets = ContentPermissionsFilter.getEncodedCredentialSets(encodedCredentials);
        for (int i = 0; i < credentialSets.size(); ++i) {
            Collection encodedCredentialSet = (Collection)credentialSets.get(i);
            if (this.checkEncodedCredentialSet(encodedCredentialSet)) continue;
            return false;
        }
        return true;
    }

    private boolean checkEncodedCredentialSet(Collection encodedCredentialSet) {
        for (String entityId : this.userCredentials) {
            if (entityId == null || !encodedCredentialSet.contains(entityId)) continue;
            return true;
        }
        return false;
    }

    static List getEncodedCredentialSets(String encodedCredentials) {
        if (!TextUtils.stringSet((String)encodedCredentials)) {
            return Collections.EMPTY_LIST;
        }
        ArrayList contentPermissionSets = new ArrayList();
        char[] chars = encodedCredentials.toCharArray();
        int currentStart = 0;
        HashSet<String> contentPermissionSet = new HashSet<String>();
        for (int k = 0; k < chars.length; ++k) {
            char aChar = chars[k];
            if (aChar == '|') {
                contentPermissionSet.add(encodedCredentials.substring(currentStart, k));
                currentStart = k + 1;
            }
            if (aChar != '&') continue;
            contentPermissionSet.add(encodedCredentials.substring(currentStart, k));
            contentPermissionSets.add(contentPermissionSet);
            contentPermissionSet = new HashSet();
            currentStart = k + 1;
        }
        contentPermissionSet.add(encodedCredentials.substring(currentStart, encodedCredentials.length()));
        contentPermissionSets.add(contentPermissionSet);
        return contentPermissionSets;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ContentPermissionsFilter that = (ContentPermissionsFilter)((Object)o);
        return !(this.userCredentials != null ? !((Object)this.userCredentials).equals(that.userCredentials) : that.userCredentials != null);
    }

    public int hashCode() {
        return this.userCredentials != null ? ((Object)this.userCredentials).hashCode() : 0;
    }
}

