/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.search.lucene.filter;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.BitSet;
import java.util.StringTokenizer;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.search.Filter;

public class OrderedNGramMatchingFilter
extends Filter {
    private final String query;
    private final String fieldName;
    private final Analyzer queryAnalyzer;

    public OrderedNGramMatchingFilter(String fieldName, String query, Analyzer queryAnalyzer) {
        if (fieldName == null) {
            throw new IllegalArgumentException("fieldName is required.");
        }
        if (queryAnalyzer == null) {
            throw new IllegalArgumentException("queryAnalyzer is required.");
        }
        this.query = query;
        this.fieldName = fieldName;
        this.queryAnalyzer = queryAnalyzer;
    }

    public BitSet bits(IndexReader reader) throws IOException {
        int maxDoc = reader.maxDoc();
        BitSet queryBitSet = null;
        StringTokenizer stringTokenizer = new StringTokenizer(this.query, " ");
        while (stringTokenizer.hasMoreTokens()) {
            String queryToken = stringTokenizer.nextToken();
            BitSet queryTokenBitSet = new BitSet(maxDoc);
            TokenStream ngramTokenStream = this.getNGrams(queryToken);
            int[] prevNGramMatchPositions = new int[maxDoc];
            Token ngramToken = ngramTokenStream.next();
            if (ngramToken == null) continue;
            TermPositions matchingDocs = reader.termPositions(new Term(this.fieldName, ngramToken.termText()));
            while (matchingDocs.next()) {
                int docId = matchingDocs.doc();
                queryTokenBitSet.set(docId);
                prevNGramMatchPositions[docId] = matchingDocs.nextPosition();
            }
            while ((ngramToken = ngramTokenStream.next()) != null && !queryTokenBitSet.isEmpty()) {
                BitSet ngramTokenBitSet = this.getBitSetForToken(queryTokenBitSet, prevNGramMatchPositions, ngramToken, reader, maxDoc);
                if (ngramTokenBitSet.isEmpty()) {
                    queryTokenBitSet = new BitSet(maxDoc);
                    continue;
                }
                queryTokenBitSet.and(ngramTokenBitSet);
            }
            if (queryTokenBitSet.isEmpty()) {
                return queryTokenBitSet;
            }
            if (queryBitSet == null) {
                queryBitSet = queryTokenBitSet;
                continue;
            }
            queryBitSet.and(queryTokenBitSet);
        }
        if (queryBitSet == null) {
            return new BitSet(maxDoc);
        }
        return queryBitSet;
    }

    private BitSet getBitSetForToken(BitSet previouslyMatchedBitSet, int[] prevNGramMatchPositions, Token ngramToken, IndexReader reader, int maxDoc) throws IOException {
        BitSet result = new BitSet(maxDoc);
        TermPositions matchingDocs = reader.termPositions(new Term(this.fieldName, ngramToken.termText()));
        block0: while (matchingDocs.next()) {
            int docId = matchingDocs.doc();
            if (!previouslyMatchedBitSet.get(docId)) continue;
            int termFreq = matchingDocs.freq();
            for (int counter = 0; counter < termFreq; ++counter) {
                if (matchingDocs.nextPosition() - prevNGramMatchPositions[docId] != 1) continue;
                result.set(docId);
                int n = docId;
                prevNGramMatchPositions[n] = prevNGramMatchPositions[n] + 1;
                continue block0;
            }
        }
        return result;
    }

    private TokenStream getNGrams(String query) {
        return this.queryAnalyzer.tokenStream(this.fieldName, (Reader)new StringReader(query));
    }
}

