/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.search.lucene.queue;

import bucket.search.persistence.IndexQueueEntry;
import bucket.search.persistence.dao.IndexQueueEntryDao;
import com.atlassian.confluence.search.lucene.IndexTask;
import com.atlassian.confluence.search.lucene.IndexTaskQueue;
import com.atlassian.confluence.search.lucene.queue.DatabaseQueueFlushedEntryCache;
import com.atlassian.confluence.search.lucene.tasks.IndexTaskFactory;
import com.atlassian.confluence.setup.BootstrapManager;
import java.io.File;
import java.io.IOException;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Category;

public class DatabaseIndexTaskQueue
implements IndexTaskQueue {
    public static final Category log = Category.getInstance(DatabaseIndexTaskQueue.class);
    private IndexQueueEntryDao queueEntryDao;
    private IndexTaskFactory indexTaskFactory;
    private BootstrapManager bootstrapManager;
    private static final String TIMESTAMP_FILENAME = ".timestamp";
    private File timestampFile;
    private static final long FUDGE_FACTOR = 1000L;
    private final DatabaseQueueFlushedEntryCache flushedEntryCache = new DatabaseQueueFlushedEntryCache(2000L);

    public void enqueue(IndexTask task) {
        IndexQueueEntry entry = this.getTaskFactory().toEntry(task);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Enqueuing task: " + entry.toString()));
        }
        if (entry != null) {
            this.queueEntryDao.saveOrUpdate(entry);
        }
    }

    public void enqueueAll(Collection tasks) {
        Iterator i = tasks.iterator();
        while (i.hasNext()) {
            this.enqueue((IndexTask)i.next());
        }
    }

    public int getSize() {
        return this.getQueuedEntries().size();
    }

    public List getQueuedEntries() {
        return this.convertToTasks(this.getUnflushedEntries());
    }

    private List removePreviouslyFlushed(List queuedEntries) {
        LinkedList<IndexQueueEntry> result = new LinkedList<IndexQueueEntry>();
        for (IndexQueueEntry entry : queuedEntries) {
            if (this.flushedEntryCache.contains(entry)) continue;
            result.add(entry);
        }
        return result;
    }

    private List convertToTasks(List entries) {
        IndexTaskFactory indexTaskFactory = this.getTaskFactory();
        LinkedList<IndexTask> tasks = new LinkedList<IndexTask>();
        for (int i = 0; i < entries.size(); ++i) {
            IndexQueueEntry entry = (IndexQueueEntry)entries.get(i);
            tasks.add(indexTaskFactory.toTask(entry));
        }
        return tasks;
    }

    private IndexTaskFactory getTaskFactory() {
        return this.indexTaskFactory;
    }

    public synchronized List flushQueue() {
        List entries = this.getUnflushedEntries();
        long flushStartTime = this.touchTimestamp();
        if (log.isDebugEnabled()) {
            log.debug((Object)("DatabaseIndexTaskQueue.flushQueue: " + entries));
        }
        this.flushedEntryCache.removeOldEntries(new Date(flushStartTime));
        this.flushedEntryCache.addEntries(entries, new Date(flushStartTime));
        return this.convertToTasks(entries);
    }

    private List getUnflushedEntries() {
        Date timeOfLastFlush = this.calculateLastFlushTime();
        log.debug((Object)("Fetching index entries added since: " + timeOfLastFlush));
        List entries = this.queueEntryDao.getNewEntries(timeOfLastFlush);
        log.debug((Object)("Fetched " + entries.size() + " entries from datbase."));
        entries = this.removePreviouslyFlushed(entries);
        log.debug((Object)("Having excluded entries that have previously been flushed, " + entries.size() + " entries remain."));
        return entries;
    }

    public Date calculateLastFlushTime() {
        Date lastFlushTime = this.getExactLastFlushTimeFromDisk();
        if (lastFlushTime == null) {
            return new Date(System.currentTimeMillis() - 120000L);
        }
        return new Date(lastFlushTime.getTime() - 1000L);
    }

    public Date getExactLastFlushTimeFromDisk() {
        File timestampFile = this.getTimestampFile();
        if (timestampFile.exists()) {
            return new Date(timestampFile.lastModified());
        }
        return null;
    }

    private synchronized long touchTimestamp() {
        long ts = System.currentTimeMillis();
        try {
            File timestamp = this.getTimestampFile();
            if (!(timestamp.exists() || timestamp.getParentFile().mkdirs() || timestamp.createNewFile())) {
                throw new IOException("Failed to create timestamp file.");
            }
            timestamp.setLastModified(ts);
        }
        catch (IOException e) {
            log.error((Object)"", (Throwable)e);
        }
        return ts;
    }

    private File getTimestampFile() {
        if (this.timestampFile == null) {
            this.timestampFile = new File(this.bootstrapManager.getFilePathProperty("lucene.index.dir"), TIMESTAMP_FILENAME);
        }
        return this.timestampFile;
    }

    public void deleteOldEntries() {
        Calendar cal = Calendar.getInstance();
        cal.add(6, -2);
        this.queueEntryDao.deleteAllBefore(cal.getTime());
    }

    public void reset() {
        this.queueEntryDao.deleteAll();
    }

    public void setQueueEntryDao(IndexQueueEntryDao queueEntryDao) {
        this.queueEntryDao = queueEntryDao;
    }

    public void setBootstrapManager(BootstrapManager bootstrapManager) {
        this.bootstrapManager = bootstrapManager;
    }

    public void setIndexTaskFactory(IndexTaskFactory indexTaskFactory) {
        this.indexTaskFactory = indexTaskFactory;
    }
}

