/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.search.lucene.tasks;

import com.atlassian.bonnie.ILuceneConnection;
import com.atlassian.bonnie.Searchable;
import com.atlassian.confluence.search.lucene.tasks.BaseContentIndexTask;
import java.io.IOException;
import java.text.ParseException;
import org.apache.log4j.Category;
import org.apache.lucene.index.IndexWriter;

public class AddDocumentIndexTask
extends BaseContentIndexTask
implements ILuceneConnection.WriterAction {
    public static final Category LOG = Category.getInstance(AddDocumentIndexTask.class);

    public AddDocumentIndexTask(Searchable target) {
        super(target);
    }

    public AddDocumentIndexTask(String handle) throws ParseException {
        super(handle);
    }

    public void perform(IndexWriter writer) throws IOException {
        try {
            Searchable searchable = this.getTarget();
            if (searchable != null) {
                writer.addDocument(this.documentBuilder.getDocument(searchable));
            } else {
                LOG.debug((Object)("Ignoring index request: " + this.getHandle() + ". Handle was not resolved."));
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"Error getting document from searchable", (Throwable)e);
        }
    }

    public String getDescription() {
        return "index.task.add";
    }
}

