/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.search.lucene.tasks;

import com.atlassian.bonnie.Handle;
import com.atlassian.bonnie.ILuceneConnection;
import com.atlassian.bonnie.Searchable;
import com.atlassian.confluence.search.lucene.tasks.BaseContentIndexTask;
import com.atlassian.confluence.spaces.Space;
import com.opensymphony.util.TextUtils;
import java.io.IOException;
import java.text.ParseException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;

public class UnIndexSpaceIndexTask
extends BaseContentIndexTask
implements ILuceneConnection.ReaderAction {
    public UnIndexSpaceIndexTask(Searchable target) {
        super(target);
    }

    protected UnIndexSpaceIndexTask(String handle) throws ParseException {
        super(handle);
    }

    protected Handle createHandle(String handle) throws ParseException {
        return new SpaceKeyHandle(handle);
    }

    protected Handle createHandle(Searchable target) {
        return new SpaceKeyHandle(((Space)target).getKey());
    }

    public String getDescription() {
        return "index.task.unindex.space";
    }

    public Object perform(IndexReader reader) throws IOException {
        Term term = new Term("spacekey", this.handle.toString());
        reader.deleteDocuments(term);
        return null;
    }

    private class SpaceKeyHandle
    implements Handle {
        private final String key;

        public SpaceKeyHandle(String key) {
            if (!TextUtils.stringSet((String)key)) {
                throw new IllegalArgumentException("Space key much be specified.");
            }
            this.key = key;
        }

        public String toString() {
            return this.key;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SpaceKeyHandle that = (SpaceKeyHandle)o;
            return this.key.equals(that.key);
        }

        public int hashCode() {
            return this.key.hashCode();
        }
    }
}

