/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.search.scope;

import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.Namespace;
import com.atlassian.confluence.search.ConfluenceSearchScope;
import com.atlassian.user.User;
import java.util.List;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

public class LabelScope
implements ConfluenceSearchScope {
    private List labels;
    private BooleanClause.Occur labelOccur = BooleanClause.Occur.SHOULD;

    public LabelScope(List labels) {
        this.labels = labels;
    }

    public LabelScope(List labels, BooleanClause.Occur labelOccur) {
        this.labels = labels;
        this.labelOccur = labelOccur;
    }

    public void restrictQuery(User user, BooleanQuery query) {
        BooleanQuery subQuery = new BooleanQuery();
        if (this.labels.isEmpty()) {
            return;
        }
        for (Label label : this.labels) {
            String labelName;
            if (Namespace.PERSONAL.equals(label.getNamespace())) {
                if (user == null) continue;
                labelName = label.toStringWithOwnerPrefix();
            } else {
                labelName = label.toStringWithNamespace();
            }
            subQuery.add((Query)new TermQuery(new Term("label", labelName)), this.labelOccur);
        }
        query.add((Query)subQuery, BooleanClause.Occur.MUST);
    }
}

