/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.search.scope;

import com.atlassian.confluence.search.ConfluenceSearchScope;
import com.atlassian.user.User;
import java.util.Date;
import org.apache.lucene.document.DateField;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreRangeQuery;
import org.apache.lucene.search.Query;

public class ModifiedInLastDaysScope
implements ConfluenceSearchScope {
    private int daysAgo;

    public ModifiedInLastDaysScope(int daysAgo) {
        this.daysAgo = daysAgo;
    }

    public void restrictQuery(User user, BooleanQuery query) {
        if (this.daysAgo == 0) {
            return;
        }
        Date startDate = new Date(System.currentTimeMillis() - (long)this.daysAgo * 86400000L);
        query.add((Query)new ConstantScoreRangeQuery("modified", DateField.dateToString((Date)startDate), null, true, false), BooleanClause.Occur.MUST);
    }
}

