/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.search.scope;

import com.atlassian.bonnie.Searcher;
import com.atlassian.confluence.search.ConfluenceSearchScope;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.user.User;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

public class TextScope
implements ConfluenceSearchScope {
    private boolean searchingMail;
    private Searcher searcher;
    private String queryString;
    private SettingsManager settingsManager;

    public TextScope(Searcher searcher, String queryString, boolean searchingMail) {
        this.searchingMail = searchingMail;
        this.searcher = searcher;
        this.queryString = queryString;
    }

    public TextScope(Searcher searcher, String queryString, boolean searchingMail, SettingsManager settingsManager) {
        this.searchingMail = searchingMail;
        this.searcher = searcher;
        this.queryString = queryString;
        this.settingsManager = settingsManager;
    }

    public void restrictQuery(User user, BooleanQuery query) {
        BooleanQuery subQuery = new BooleanQuery();
        this.addDefaultTextFields(subQuery);
        if (this.searchingMail) {
            this.addMailTextFields(subQuery);
        }
        query.add((Query)subQuery, BooleanClause.Occur.MUST);
    }

    private void addMailTextFields(BooleanQuery query) {
        Query fromQuery = this.searcher.buildStandardQuery(new String[]{"from"}, this.queryString);
        fromQuery.setBoost(9.0f);
        query.add(fromQuery, BooleanClause.Occur.SHOULD);
        Query messageIdQuery = this.makeKeywordQuery("messageid", 9);
        query.add(messageIdQuery, BooleanClause.Occur.SHOULD);
        Query inReplyToQuery = this.makeKeywordQuery("inreplyto", 5);
        query.add(inReplyToQuery, BooleanClause.Occur.SHOULD);
        Query referencesQuery = this.makeKeywordQuery("references", 1);
        query.add(referencesQuery, BooleanClause.Occur.SHOULD);
        query.add(this.searcher.buildStandardQuery(new String[]{"recipients"}, this.queryString), BooleanClause.Occur.SHOULD);
    }

    private void addDefaultTextFields(BooleanQuery query) {
        Query titleQuery = this.searcher.buildStandardQuery(new String[]{"title"}, this.queryString);
        titleQuery.setBoost(9.0f);
        query.add(titleQuery, BooleanClause.Occur.SHOULD);
        Query labelQuery = this.searcher.buildStandardQuery(new String[]{"labelText"}, this.queryString);
        labelQuery.setBoost(7.0f);
        query.add(labelQuery, BooleanClause.Occur.SHOULD);
        Query contentQuery = this.searcher.buildStandardQuery(new String[]{"contentBody"}, this.queryString);
        contentQuery.setBoost(5.0f);
        query.add(contentQuery, BooleanClause.Occur.SHOULD);
        query.add(this.searcher.buildStandardQuery(new String[]{"filename"}, this.queryString), BooleanClause.Occur.SHOULD);
        if (!this.settingsManager.getGlobalSettings().isSharedMode()) {
            query.add(this.searcher.buildStandardQuery(new String[]{"username", "fullName", "email"}, this.queryString), BooleanClause.Occur.SHOULD);
        }
    }

    private Query makeKeywordQuery(String fieldName, int boost) {
        TermQuery query = new TermQuery(new Term(fieldName, this.queryString));
        if (boost > 0) {
            query.setBoost((float)boost);
        }
        return query;
    }
}

