/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.search.scope;

import com.atlassian.confluence.search.ConfluenceSearchScope;
import com.atlassian.confluence.search.service.ContentTypeEnum;
import com.atlassian.user.User;
import java.util.List;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

public class TypeScope
implements ConfluenceSearchScope {
    private final List types;

    public TypeScope(List types) {
        this.types = types;
    }

    public void restrictQuery(User user, BooleanQuery query) {
        if (this.types == null || this.types.isEmpty()) {
            return;
        }
        BooleanQuery subQuery = new BooleanQuery();
        for (String type : this.types) {
            ContentTypeEnum typeEnum = ContentTypeEnum.get(type);
            String typeClass = null;
            if (typeEnum != null) {
                typeClass = typeEnum.getTypeClass();
            }
            subQuery.add((Query)new TermQuery(new Term("classname", typeClass)), BooleanClause.Occur.SHOULD);
        }
        query.add((Query)subQuery, BooleanClause.Occur.MUST);
    }
}

