/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.search.service;

import com.atlassian.bonnie.Searchable;
import com.atlassian.confluence.core.Addressable;
import com.atlassian.confluence.event.events.search.SearchPerformedEvent;
import com.atlassian.confluence.search.service.PredefinedQueryBuilder;
import com.atlassian.confluence.search.service.SearchQueryParameters;
import com.atlassian.confluence.search.service.SearchService;
import com.atlassian.confluence.search.v2.InvalidSearchException;
import com.atlassian.confluence.search.v2.Search;
import com.atlassian.confluence.search.v2.SearchManager;
import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.confluence.search.v2.SearchResults;
import com.atlassian.confluence.search.v2.filter.SubsetResultFilter;
import com.atlassian.confluence.search.v2.lucene.LuceneSearchResults;
import com.atlassian.confluence.search.v2.query.AllQuery;
import com.atlassian.confluence.search.v2.searchfilter.AuthorSearchFilter;
import com.atlassian.confluence.search.v2.searchfilter.ContentPermissionsSearchFilter;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.event.Event;
import com.atlassian.event.EventManager;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSearchService
implements SearchService {
    private static final Logger logger = Logger.getLogger(DefaultSearchService.class);
    private PredefinedQueryBuilder predefinedQueryBuilder;
    private SearchManager searchManager;
    private EventManager eventManager;

    @Override
    public SearchResults search(SearchQueryParameters searchQueryParams, int startIndex, int pageSize) {
        SearchResults searchResults;
        if (searchQueryParams == null) {
            throw new IllegalArgumentException("The searchQueryParams must be supplied.");
        }
        if (startIndex < 0) {
            throw new IllegalArgumentException("The startIndex must be greater than 0.");
        }
        if (pageSize <= 0) {
            throw new IllegalArgumentException("The pageSize must be greater than 0.");
        }
        if (searchQueryParams.getCategory() != null) {
            searchQueryParams.setSpaceKeys(null);
        }
        SearchQuery searchQuery = this.predefinedQueryBuilder.siteSearchQuery(searchQueryParams);
        ContentPermissionsSearchFilter contentPermissionsFilter = ContentPermissionsSearchFilter.getInstance();
        try {
            searchResults = this.searchManager.search(new Search(searchQuery, null, contentPermissionsFilter, new SubsetResultFilter(startIndex, pageSize)));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid query params specified: [" + searchQueryParams + "] produced an invalid search query.", e);
        }
        catch (InvalidSearchException e) {
            return LuceneSearchResults.EMPTY_RESULTS;
        }
        this.eventManager.publishEvent((Event)new SearchPerformedEvent((Object)this, searchQuery, AuthenticatedUserThreadLocal.getUser(), searchResults.size()));
        return searchResults;
    }

    @Override
    public SearchResults searchUsers(String query, int maxResults) {
        if (maxResults <= 0) {
            throw new IllegalArgumentException("maxResults must be greater than 0");
        }
        if (StringUtils.isBlank((String)query)) {
            return LuceneSearchResults.EMPTY_RESULTS;
        }
        AllQuery searchQuery = new AllQuery();
        AuthorSearchFilter searchFilter = new AuthorSearchFilter(query);
        SearchResults searchResults = null;
        try {
            searchResults = this.searchManager.search(new Search(searchQuery, null, searchFilter, new SubsetResultFilter(0, maxResults)));
            this.eventManager.publishEvent((Event)new SearchPerformedEvent((Object)this, searchQuery, AuthenticatedUserThreadLocal.getUser(), searchResults.size()));
        }
        catch (InvalidSearchException e) {
            logger.warn((Object)("Error performing a search for users with: " + query), (Throwable)e);
        }
        return searchResults;
    }

    @Override
    public List<Addressable> convertToAddressable(SearchResults results) {
        List<Searchable> entities = this.searchManager.convertToEntities(results, true);
        ArrayList<Addressable> addressables = new ArrayList<Addressable>(entities.size());
        for (Searchable searchable : entities) {
            addressables.add((Addressable)searchable);
        }
        return addressables;
    }

    public void setPredefinedQueryBuilder(PredefinedQueryBuilder predefinedQueryBuilder) {
        this.predefinedQueryBuilder = predefinedQueryBuilder;
    }

    public void setSearchManager(SearchManager searchManager) {
        this.searchManager = searchManager;
    }

    public void setEventManager(EventManager eventManager) {
        this.eventManager = eventManager;
    }
}

