/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.search.service;

import com.atlassian.confluence.search.service.ContentTypeEnum;
import com.atlassian.confluence.search.service.SpaceCategoryEnum;
import com.atlassian.confluence.search.v2.query.DateRangeQuery;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchQueryParameters {
    private String query;
    private SpaceCategoryEnum category;
    private Set<String> spaceKeys;
    private ContentTypeEnum contentType;
    private DateRangeQuery.DateRange lastModified;
    private String contributor;

    public SearchQueryParameters() {
    }

    public SearchQueryParameters(String query) {
        this.query = query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public void setCategory(SpaceCategoryEnum category) {
        if (category != null) {
            this.category = category;
        }
    }

    public void setSpaceKey(String spaceKey) {
        if (StringUtils.isNotBlank((String)spaceKey)) {
            this.spaceKeys = Collections.singleton(spaceKey);
        }
    }

    public void setSpaceKeys(Set<String> spaceKeys) {
        this.spaceKeys = spaceKeys;
    }

    public void setContentType(ContentTypeEnum contentType) {
        this.contentType = contentType;
    }

    public void setLastModified(DateRangeQuery.DateRange lastModified) {
        this.lastModified = lastModified;
    }

    public void setContributor(String creator) {
        this.contributor = creator;
    }

    public String getQuery() {
        return this.query;
    }

    public SpaceCategoryEnum getCategory() {
        return this.category;
    }

    public Set<String> getSpaceKeys() {
        return this.spaceKeys;
    }

    public ContentTypeEnum getContentType() {
        return this.contentType;
    }

    public DateRangeQuery.DateRange getLastModified() {
        return this.lastModified;
    }

    public String getContributor() {
        return this.contributor;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("query", (Object)this.query).append("category", (Object)this.category).append("spaceKeys", this.spaceKeys).append("contentType", (Object)this.contentType).append("lastModified", (Object)this.lastModified).append("contributor", (Object)this.contributor).toString();
    }
}

