/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.search.v2;

import com.atlassian.confluence.plugin.descriptor.search.SearchQueryModuleDescriptor;
import com.atlassian.confluence.search.v2.InvalidQueryException;
import com.atlassian.confluence.search.v2.QueryFactory;
import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.plugin.PluginAccessor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.List;

public class DefaultQueryFactory
implements QueryFactory {
    private final PluginAccessor pluginAccessor;
    private static final String BUILTIN_SEARCH_PLUGIN_KEY = "confluence.search.builtin";

    public DefaultQueryFactory(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    public SearchQuery newQuery(String queryKey) throws InvalidQueryException {
        return this.newQuery(queryKey, Collections.EMPTY_LIST);
    }

    public SearchQuery newQuery(String queryKey, List parameters) throws InvalidQueryException {
        SearchQueryModuleDescriptor moduleDescriptor;
        if (queryKey.indexOf(":") < 0) {
            queryKey = "confluence.search.builtin:" + queryKey;
        }
        if ((moduleDescriptor = (SearchQueryModuleDescriptor)this.pluginAccessor.getEnabledPluginModule(queryKey)) == null) {
            throw new InvalidQueryException("Unable to find query plugin module: " + queryKey);
        }
        Class moduleClass = moduleDescriptor.getModuleClass();
        try {
            return moduleDescriptor.newQuery(parameters);
        }
        catch (InstantiationException e) {
            throw new InvalidQueryException("Unable to instantiate query module class: " + moduleClass.getName() + " : " + e.toString());
        }
        catch (NoSuchMethodException e) {
            throw new InvalidQueryException("Unable to instantiate query module class: " + moduleClass.getName() + " : " + e.toString());
        }
        catch (IllegalAccessException e) {
            throw new InvalidQueryException("Unable to instantiate query module class: " + moduleClass.getName() + " : " + e.toString());
        }
        catch (InvocationTargetException e) {
            throw new InvalidQueryException("Unable to instantiate query module class: " + moduleClass.getName() + " : " + e.toString());
        }
    }
}

