/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.search.v2.lucene;

import com.atlassian.confluence.search.v2.ResultFilter;
import com.atlassian.confluence.search.v2.SearchFilter;
import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.confluence.search.v2.SearchSort;
import com.atlassian.confluence.search.v2.lucene.LuceneMapperNotFoundException;
import com.atlassian.confluence.search.v2.lucene.LuceneQueryMapper;
import com.atlassian.confluence.search.v2.lucene.LuceneResultFilter;
import com.atlassian.confluence.search.v2.lucene.LuceneResultFilterMapper;
import com.atlassian.confluence.search.v2.lucene.LuceneSearchFilterMapper;
import com.atlassian.confluence.search.v2.lucene.LuceneSearchMapper;
import com.atlassian.confluence.search.v2.lucene.LuceneSearchMapperRegistry;
import com.atlassian.confluence.search.v2.lucene.LuceneSortMapper;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;

public class DelegatingLuceneSearchMapper
implements LuceneSearchMapper {
    private LuceneSearchMapperRegistry registry;

    public DelegatingLuceneSearchMapper(LuceneSearchMapperRegistry registry) {
        this.registry = registry;
    }

    public Query convertToLuceneQuery(SearchQuery query) {
        LuceneQueryMapper luceneQueryMapper = this.registry.getQueryMapper(query.getKey());
        if (luceneQueryMapper == null) {
            throw new LuceneMapperNotFoundException(SearchQuery.class, query.getKey());
        }
        return luceneQueryMapper.convertToLuceneQuery(query);
    }

    public Sort convertToLuceneSort(SearchSort searchSort) {
        LuceneSortMapper luceneSortMapper = this.registry.getSortMapper(searchSort.getKey());
        if (luceneSortMapper == null) {
            throw new LuceneMapperNotFoundException(SearchSort.class, searchSort.getKey());
        }
        return luceneSortMapper.convertToLuceneSort(searchSort);
    }

    public LuceneResultFilter convertToLuceneResultFilter(ResultFilter resultFilter) {
        LuceneResultFilterMapper luceneResultFilterMapper = this.registry.getResultFilterMapper(resultFilter.getKey());
        if (luceneResultFilterMapper == null) {
            throw new LuceneMapperNotFoundException(ResultFilter.class, resultFilter.getKey());
        }
        return luceneResultFilterMapper.convertToLuceneResultFilter(resultFilter);
    }

    public Filter convertToLuceneSearchFilter(SearchFilter searchFilter) {
        LuceneSearchFilterMapper luceneSearchFilterMapper = this.registry.getSearchFilterMapper(searchFilter.getKey());
        if (luceneSearchFilterMapper == null) {
            throw new LuceneMapperNotFoundException(SearchFilter.class, searchFilter.getKey());
        }
        return luceneSearchFilterMapper.convertToLuceneSearchFilter(searchFilter);
    }
}

