/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.search.v2.lucene;

import com.atlassian.bonnie.ILuceneConnection;
import com.atlassian.confluence.search.v2.lucene.LuceneResultFilter;
import com.atlassian.confluence.search.v2.lucene.LuceneSearchResults;
import com.atlassian.confluence.search.v2.lucene.LuceneSearcher;
import com.atlassian.confluence.search.v2.lucene.SearcherAction;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.user.User;
import com.atlassian.util.profiling.UtilTimerStack;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TermQuery;

public class LuceneSearcherImpl
implements LuceneSearcher {
    public static final Logger log = Logger.getLogger(LuceneSearcherImpl.class);
    private ILuceneConnection luceneConnection;
    private UserAccessor userAccessor;
    private SpaceManager spaceManager;

    public LuceneSearcherImpl(ILuceneConnection luceneConnection, UserAccessor userAccessor, SpaceManager spaceManager) {
        this.luceneConnection = luceneConnection;
        this.userAccessor = userAccessor;
        this.spaceManager = spaceManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LuceneSearchResults search(Query query, Sort sort, Filter searchFilter, LuceneResultFilter resultFilter) {
        UtilTimerStack.push((String)"LuceneSearcherImpl.search()");
        try {
            User currentUser = AuthenticatedUserThreadLocal.getUser();
            Query secureQuery = this.getQueryLimitedToVisibleSpaces(currentUser, query);
            SearcherAction searcherAction = new SearcherAction(secureQuery, searchFilter, sort, resultFilter);
            this.luceneConnection.withSearch((ILuceneConnection.SearcherAction)searcherAction);
            LuceneSearchResults luceneSearchResults = new LuceneSearchResults(searcherAction.getResults(), searcherAction.getUnfilteredResultsCount());
            return luceneSearchResults;
        }
        catch (BooleanQuery.TooManyClauses tmc) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Error encountered in lucene search: " + tmc.getMessage()), (Throwable)tmc);
            } else {
                log.warn((Object)("Error encounterd in lucene search: " + tmc.getMessage()));
            }
            LuceneSearchResults luceneSearchResults = new LuceneSearchResults(Collections.EMPTY_LIST, 0);
            return luceneSearchResults;
        }
        catch (RuntimeException e) {
            if (e.getMessage() != null && e.getMessage().endsWith("no terms in field modified - cannot determine sort type")) {
                log.info((Object)"Error encountered in lucene search - most likely empty index", (Throwable)e);
            } else {
                log.error((Object)("Error encountered in lucene search: " + e.getMessage()), (Throwable)e);
            }
            UtilTimerStack.pop((String)"LuceneSmartListManager.performLuceneQuery");
            LuceneSearchResults luceneSearchResults = new LuceneSearchResults(Collections.EMPTY_LIST, 0);
            return luceneSearchResults;
        }
        finally {
            UtilTimerStack.pop((String)"LuceneSearcherImpl.search()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Query getQueryLimitedToVisibleSpaces(User currentUser, Query query) {
        String profileString = "LuceneSearcherImpl.getQueryLimitedToVisibleSpaces(" + currentUser + ")";
        UtilTimerStack.push((String)profileString);
        try {
            if (this.userAccessor.isSuperUser(currentUser)) {
                Query query2 = query;
                return query2;
            }
            List allSpaces = this.spaceManager.getAllSpaces();
            List visibleSpaces = this.spaceManager.getPermittedSpaces(currentUser);
            BooleanQuery secureQuery = new BooleanQuery();
            secureQuery.add(query, BooleanClause.Occur.MUST);
            this.restrictQueryByInvisibleSpaces(secureQuery, allSpaces, visibleSpaces);
            BooleanQuery booleanQuery = secureQuery;
            return booleanQuery;
        }
        finally {
            UtilTimerStack.pop((String)profileString);
        }
    }

    private void restrictQueryByInvisibleSpaces(BooleanQuery query, List allSpaces, List visibleSpaces) {
        BooleanQuery.setMaxClauseCount((int)Math.max(allSpaces.size() - visibleSpaces.size() + 100, 1024));
        HashSet visibleSpacesSet = new HashSet(visibleSpaces);
        for (Space space : allSpaces) {
            if (visibleSpacesSet.contains(space)) continue;
            query.add((Query)new TermQuery(new Term("spacekey", space.getKey())), BooleanClause.Occur.MUST_NOT);
        }
    }
}

