/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.search.v2.lucene;

import com.atlassian.confluence.search.v2.lucene.LuceneResultFilter;
import com.atlassian.confluence.search.v2.lucene.WrappedHit;

public class LuceneSubsetResultFilter
implements LuceneResultFilter {
    private final int startOffset;
    private final int count;
    private int currentOffset = -1;

    public LuceneSubsetResultFilter(int count) {
        this(0, count);
    }

    public LuceneSubsetResultFilter(int startOffset, int count) {
        this.startOffset = startOffset;
        this.count = count;
    }

    public boolean isIncludedInResults(WrappedHit hit) {
        ++this.currentOffset;
        return this.currentOffset >= this.startOffset && this.currentOffset < this.startOffset + this.count;
    }

    public boolean shouldContinueIterating() {
        return this.count != 0 && this.currentOffset + 1 < this.startOffset + this.count;
    }

    public int getExpectedResultsCount() {
        return this.count;
    }
}

