/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.search.v2.lucene;

import com.atlassian.confluence.plugin.CompositeModuleDescriptorPredicate;
import com.atlassian.confluence.plugin.descriptor.search.AbstractLuceneMapperModuleDescriptor;
import com.atlassian.confluence.plugin.descriptor.search.LuceneQueryMapperModuleDescriptor;
import com.atlassian.confluence.plugin.descriptor.search.LuceneResultFilterMapperModuleDescriptor;
import com.atlassian.confluence.plugin.descriptor.search.LuceneSearchFilterMapperModuleDescriptor;
import com.atlassian.confluence.plugin.descriptor.search.LuceneSortMapperModuleDescriptor;
import com.atlassian.confluence.search.v2.lucene.LuceneMapperPredicate;
import com.atlassian.confluence.search.v2.lucene.LuceneQueryMapper;
import com.atlassian.confluence.search.v2.lucene.LuceneResultFilterMapper;
import com.atlassian.confluence.search.v2.lucene.LuceneSearchFilterMapper;
import com.atlassian.confluence.search.v2.lucene.LuceneSearchMapperRegistry;
import com.atlassian.confluence.search.v2.lucene.LuceneSortMapper;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.predicate.EnabledModulePredicate;
import com.atlassian.plugin.predicate.ModuleDescriptorPredicate;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluggableLuceneSearchMapperRegistry
implements LuceneSearchMapperRegistry {
    private final Logger log = Logger.getLogger(PluggableLuceneSearchMapperRegistry.class);
    protected PluginAccessor pluginAccessor;

    public PluggableLuceneSearchMapperRegistry(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    @Override
    public LuceneQueryMapper getQueryMapper(String key) {
        return (LuceneQueryMapper)this.getMappingPluginModule(key, LuceneQueryMapperModuleDescriptor.class, "searches of type: ");
    }

    @Override
    public LuceneSortMapper getSortMapper(String key) {
        return (LuceneSortMapper)this.getMappingPluginModule(key, LuceneSortMapperModuleDescriptor.class, "sort orders of type: ");
    }

    @Override
    public LuceneResultFilterMapper getResultFilterMapper(String key) {
        return (LuceneResultFilterMapper)this.getMappingPluginModule(key, LuceneResultFilterMapperModuleDescriptor.class, "result filters of type: ");
    }

    @Override
    public LuceneSearchFilterMapper getSearchFilterMapper(String key) {
        return (LuceneSearchFilterMapper)this.getMappingPluginModule(key, LuceneSearchFilterMapperModuleDescriptor.class, "search filters of type: ");
    }

    private Object getMappingPluginModule(String handleKey, Class<? extends AbstractLuceneMapperModuleDescriptor> moduleType, String errorTypeDescription) {
        CompositeModuleDescriptorPredicate queryModulePredicate = new CompositeModuleDescriptorPredicate((ModuleDescriptorPredicate)new EnabledModulePredicate(this.pluginAccessor), new LuceneMapperPredicate(moduleType, handleKey));
        Collection mappers = this.pluginAccessor.getModules((ModuleDescriptorPredicate)queryModulePredicate);
        if (mappers.size() == 0) {
            return null;
        }
        if (mappers.size() > 1) {
            this.warnMultiplePluginsInstalled(queryModulePredicate, errorTypeDescription + handleKey);
        }
        return mappers.iterator().next();
    }

    private void warnMultiplePluginsInstalled(ModuleDescriptorPredicate queryModulePredicate, String description) {
        Collection moduleDescriptors = this.pluginAccessor.getModuleDescriptors(queryModulePredicate);
        ArrayList<String> moduleKeys = new ArrayList<String>(moduleDescriptors.size());
        for (ModuleDescriptor descriptor : moduleDescriptors) {
            moduleKeys.add(descriptor.getCompleteKey());
        }
        this.log.warn((Object)("Multiple plugins provide lucene mappings for " + description + ". " + "This may result in unpredictable search results. " + "You should disable all but one of the following plugin modules: " + moduleKeys));
    }
}

