/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.search.v2.lucene;

import com.atlassian.confluence.plugin.CompositeModuleDescriptorPredicate;
import com.atlassian.confluence.plugin.descriptor.search.AbstractLuceneMapperModuleDescriptor;
import com.atlassian.confluence.search.v2.lucene.LuceneMapperClassPredicate;
import com.atlassian.confluence.search.v2.lucene.LuceneQueryMapper;
import com.atlassian.confluence.search.v2.lucene.LuceneResultFilterMapper;
import com.atlassian.confluence.search.v2.lucene.LuceneSearchFilterMapper;
import com.atlassian.confluence.search.v2.lucene.LuceneSortMapper;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.predicate.EnabledModulePredicate;
import com.atlassian.plugin.predicate.ModuleDescriptorPredicate;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchMappersThreadLocal {
    private static Logger log = Logger.getLogger(SearchMappersThreadLocal.class);
    private static ThreadLocal<SearchMappers> threadLocal = new ThreadLocal();

    public static void findAndSetMappers(PluginAccessor pluginAccessor) {
        CompositeModuleDescriptorPredicate queryModulePredicate = new CompositeModuleDescriptorPredicate((ModuleDescriptorPredicate)new EnabledModulePredicate(pluginAccessor), new LuceneMapperClassPredicate(AbstractLuceneMapperModuleDescriptor.class));
        Collection moduleDescriptors = pluginAccessor.getModuleDescriptors((ModuleDescriptorPredicate)queryModulePredicate);
        HashMap<String, LuceneQueryMapper> queryMappers = new HashMap<String, LuceneQueryMapper>(10);
        HashMap<String, LuceneSortMapper> sortMappers = new HashMap<String, LuceneSortMapper>(3);
        HashMap<String, LuceneResultFilterMapper> resultMappers = new HashMap<String, LuceneResultFilterMapper>(1);
        HashMap<String, LuceneSearchFilterMapper> searchFilterMappers = new HashMap<String, LuceneSearchFilterMapper>(2);
        for (AbstractLuceneMapperModuleDescriptor desc : moduleDescriptors) {
            Class moduleClass = desc.getModuleClass();
            if (LuceneQueryMapper.class.isAssignableFrom(moduleClass)) {
                SearchMappersThreadLocal.addModuleToMap(queryMappers, desc);
                continue;
            }
            if (LuceneSortMapper.class.isAssignableFrom(moduleClass)) {
                SearchMappersThreadLocal.addModuleToMap(sortMappers, desc);
                continue;
            }
            if (LuceneResultFilterMapper.class.isAssignableFrom(moduleClass)) {
                SearchMappersThreadLocal.addModuleToMap(resultMappers, desc);
                continue;
            }
            if (!LuceneSearchFilterMapper.class.isAssignableFrom(moduleClass)) continue;
            SearchMappersThreadLocal.addModuleToMap(searchFilterMappers, desc);
        }
        SearchMappers mappers = new SearchMappers(queryMappers, sortMappers, resultMappers, searchFilterMappers);
        threadLocal.set(mappers);
    }

    private static void addModuleToMap(Map pluginsByKey, AbstractLuceneMapperModuleDescriptor descriptor) {
        Collection<String> keys = descriptor.getHandledKeys();
        for (String key : keys) {
            if (pluginsByKey.containsKey(key)) {
                log.warn((Object)("There are multiple mappers availabled to handle query components with the key " + key + ". Only the last one found will be used."));
            }
            pluginsByKey.put(key, descriptor.getModule());
        }
    }

    public static Map<String, LuceneQueryMapper> getQueryMappers() {
        SearchMappers mappers = threadLocal.get();
        if (mappers != null) {
            return mappers.queryMappers;
        }
        return null;
    }

    public static Map<String, LuceneSortMapper> getSortMappers() {
        SearchMappers mappers = threadLocal.get();
        if (mappers != null) {
            return mappers.sortMappers;
        }
        return null;
    }

    public static Map<String, LuceneResultFilterMapper> getResultFilterMappers() {
        SearchMappers mappers = threadLocal.get();
        if (mappers != null) {
            return mappers.resultFilterMappers;
        }
        return null;
    }

    public static Map<String, LuceneSearchFilterMapper> getSearchFilterMappers() {
        SearchMappers mappers = threadLocal.get();
        if (mappers != null) {
            return mappers.searchFilterMappers;
        }
        return null;
    }

    public static void clearAllMappers() {
        threadLocal.remove();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SearchMappers {
        Map<String, LuceneQueryMapper> queryMappers;
        Map<String, LuceneSortMapper> sortMappers;
        Map<String, LuceneResultFilterMapper> resultFilterMappers;
        Map<String, LuceneSearchFilterMapper> searchFilterMappers;

        SearchMappers(Map<String, LuceneQueryMapper> query, Map<String, LuceneSortMapper> sort, Map<String, LuceneResultFilterMapper> result, Map<String, LuceneSearchFilterMapper> searchFilterMappers) {
            this.queryMappers = query;
            this.sortMappers = sort;
            this.resultFilterMappers = result;
            this.searchFilterMappers = searchFilterMappers;
        }
    }
}

