/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.search.v2.lucene.compatibility;

import com.atlassian.confluence.core.ListQuery;
import com.atlassian.confluence.search.scope.SpaceScope;
import com.atlassian.confluence.search.service.ContentTypeEnum;
import com.atlassian.confluence.search.service.SpaceCategoryEnum;
import com.atlassian.confluence.search.v2.Search;
import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.confluence.search.v2.SearchSort;
import com.atlassian.confluence.search.v2.filter.SubsetResultFilter;
import com.atlassian.confluence.search.v2.query.BooleanQuery;
import com.atlassian.confluence.search.v2.query.ContentTypeQuery;
import com.atlassian.confluence.search.v2.query.DateRangeQuery;
import com.atlassian.confluence.search.v2.query.InSpaceQuery;
import com.atlassian.confluence.search.v2.query.LabelQuery;
import com.atlassian.confluence.search.v2.query.SpaceCategoryQuery;
import com.atlassian.confluence.search.v2.searchfilter.ContentPermissionsSearchFilter;
import com.atlassian.confluence.search.v2.sort.AbstractSort;
import com.atlassian.confluence.search.v2.sort.CreatedSort;
import com.atlassian.confluence.search.v2.sort.ModifiedSort;
import com.atlassian.confluence.spaces.Space;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.lucene.search.BooleanClause;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListQueryToSearchConverter {
    public static final Logger log = Logger.getLogger(ListQueryToSearchConverter.class);

    public static Search convertToSearch(ListQuery listQuery) {
        SearchSort sort = ListQueryToSearchConverter.convertToSearchSort(listQuery.getSortBy());
        int maxResults = listQuery.getMaxResults();
        SearchQuery searchQuery = ListQueryToSearchConverter.convertToSearchQuery(listQuery);
        ContentPermissionsSearchFilter contentPermissionsFilter = ContentPermissionsSearchFilter.getInstance();
        return new Search(searchQuery, sort, contentPermissionsFilter, new SubsetResultFilter(0, maxResults));
    }

    private static SearchSort convertToSearchSort(String sortBy) {
        AbstractSort sort;
        if ("created".equals(sortBy)) {
            sort = new CreatedSort(SearchSort.Order.DESCENDING);
        } else if ("modified".equals(sortBy)) {
            sort = new ModifiedSort(SearchSort.Order.DESCENDING);
        } else {
            log.warn((Object)("Unrecognised search sort order: " + sortBy + ", defaulting to sort by date modified"));
            sort = new ModifiedSort(SearchSort.Order.DESCENDING);
        }
        return sort;
    }

    static SearchQuery convertToSearchQuery(ListQuery listQuery) {
        HashSet<SearchQuery> componentQueries = new HashSet<SearchQuery>();
        List contentTypes = listQuery.getTypeList();
        if (!contentTypes.isEmpty()) {
            ArrayList<ContentTypeEnum> typeEnums = new ArrayList<ContentTypeEnum>(contentTypes.size());
            for (String ct : contentTypes) {
                ContentTypeEnum cte = ContentTypeEnum.get(ct);
                if (cte == null) continue;
                typeEnums.add(cte);
            }
            componentQueries.add(new ContentTypeQuery(typeEnums));
        }
        LinkedHashSet<String> spaceKeys = new LinkedHashSet<String>();
        LinkedHashSet<String> spaceScopeKeys = new LinkedHashSet<String>();
        ListQueryToSearchConverter.fillInKeysAndScopesFromSpaceList(listQuery.getSpaceList(), spaceScopeKeys, spaceKeys);
        ListQueryToSearchConverter.fillInKeysAndScopesFromScopeList(listQuery.getSpaceScopes(), spaceScopeKeys, spaceKeys);
        SearchQuery spaceSearchQueryComponent = ListQueryToSearchConverter.composeSpaceLimitingQuery(spaceKeys, spaceScopeKeys);
        if (spaceSearchQueryComponent != null) {
            componentQueries.add(spaceSearchQueryComponent);
        }
        List labelList = listQuery.getLabelList();
        HashSet<LabelQuery> labelQueries = new HashSet<LabelQuery>();
        BooleanClause.Occur occur = listQuery.getLabelOccur();
        Iterator it = labelList.iterator();
        while (it.hasNext()) {
            labelQueries.add(new LabelQuery((String)it.next()));
        }
        if (!labelQueries.isEmpty()) {
            if (occur.equals(BooleanClause.Occur.SHOULD)) {
                componentQueries.add(BooleanQuery.composeOrQuery(labelQueries));
            } else if (occur.equals(BooleanClause.Occur.MUST)) {
                componentQueries.add(BooleanQuery.composeAndQuery(labelQueries));
            } else {
                throw new IllegalArgumentException("Unhandled value of label occur: " + labelList);
            }
        }
        if (componentQueries.isEmpty() && spaceScopeKeys.isEmpty() && spaceKeys.isEmpty()) {
            throw new IllegalArgumentException("Can not perform an empty list query. Spaces: " + spaceKeys + ", Scopes: " + spaceScopeKeys);
        }
        int daysAgo = (int)listQuery.getTimeSpan();
        int n = daysAgo = daysAgo == 0 ? 7 : daysAgo;
        if (daysAgo != -1) {
            Calendar fromDate = Calendar.getInstance();
            fromDate.add(6, -daysAgo);
            componentQueries.add(new DateRangeQuery(new DateRangeQuery.DateRange(fromDate.getTime(), null, true, false), DateRangeQuery.DateRangeQueryType.MODIFIED));
        }
        return BooleanQuery.composeAndQuery(componentQueries);
    }

    private static void fillInKeysAndScopesFromScopeList(List spaceScopes, Set spaceScopeKeys, Set spaceKeys) {
        for (String key : spaceScopes) {
            if (SpaceScope.AVAILABLE_SCOPES.contains(key)) {
                spaceScopeKeys.add(key);
                continue;
            }
            spaceKeys.add(key);
        }
    }

    private static void fillInKeysAndScopesFromSpaceList(List spaceList, Set spaceScopeKeys, Set spaceKeys) {
        for (Space space : spaceList) {
            String key = space.getKey();
            if (SpaceScope.AVAILABLE_SCOPES.contains(key)) {
                spaceScopeKeys.add(key);
                continue;
            }
            spaceKeys.add(key);
        }
    }

    private static SearchQuery composeSpaceLimitingQuery(Set<String> spaceKeys, Set<String> spaceScopeKeys) {
        boolean isRestrictedToSpecificSpaceKeys;
        boolean bl = isRestrictedToSpecificSpaceKeys = (!spaceScopeKeys.isEmpty() || !spaceKeys.isEmpty()) && !spaceScopeKeys.contains(SpaceCategoryEnum.ALL.getRepresentation());
        if (!isRestrictedToSpecificSpaceKeys) {
            return null;
        }
        boolean includesFavourites = spaceScopeKeys.contains(SpaceCategoryEnum.FAVOURITES.getRepresentation());
        boolean limitToPersonal = spaceScopeKeys.contains(SpaceCategoryEnum.PERSONAL.getRepresentation());
        boolean limitToGlobal = spaceScopeKeys.contains(SpaceCategoryEnum.GLOBAL.getRepresentation());
        HashSet<SearchQuery> searchQueryComponents = new HashSet<SearchQuery>();
        HashSet<SpaceCategoryEnum> spaceCategories = new HashSet<SpaceCategoryEnum>();
        if (includesFavourites) {
            spaceCategories.add(SpaceCategoryEnum.FAVOURITES);
        }
        if (limitToPersonal) {
            spaceCategories.add(SpaceCategoryEnum.PERSONAL);
        }
        if (limitToGlobal) {
            spaceCategories.add(SpaceCategoryEnum.GLOBAL);
        }
        if (!spaceCategories.isEmpty()) {
            searchQueryComponents.add(new SpaceCategoryQuery(spaceCategories));
        }
        if (!spaceKeys.isEmpty()) {
            searchQueryComponents.add(new InSpaceQuery(spaceKeys));
        }
        if (searchQueryComponents.isEmpty()) {
            throw new IllegalArgumentException("No valid space scoping is defined in the list query. Spaces: " + spaceKeys + ", Scopes: " + spaceScopeKeys);
        }
        return BooleanQuery.composeOrQuery(searchQueryComponents);
    }
}

