/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.search.v2.lucene.compatibility;

import com.atlassian.bonnie.LuceneUtils;
import com.atlassian.confluence.search.actions.SearchResultWithExcerpt;
import com.atlassian.confluence.search.v2.SearchResult;
import com.atlassian.confluence.search.v2.SearchResults;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class SearchResultToSearchResultWithExcerptConverter {
    public static List convertToSearchResultWithExcerpt(SearchResults results) {
        ArrayList<SearchResultWithExcerpt> convertedResults = new ArrayList<SearchResultWithExcerpt>(results.size());
        Iterator<SearchResult> iterator = results.iterator();
        while (iterator.hasNext()) {
            SearchResult result = iterator.next();
            convertedResults.add(SearchResultToSearchResultWithExcerptConverter.convertToSearchResultWithExcerpt(result));
        }
        return convertedResults;
    }

    public static SearchResultWithExcerpt convertToSearchResultWithExcerpt(SearchResult result) {
        HashMap<String, String> backingMap = new HashMap<String, String>();
        backingMap.put("handle", result.getHandle().toString());
        if (result.isHomePage()) {
            backingMap.put("homePage", "true");
        }
        if (result.getCreationDate() != null) {
            backingMap.put("created", LuceneUtils.dateToString((Date)result.getCreationDate()));
        }
        if (result.getLastModificationDate() != null) {
            backingMap.put("modified", LuceneUtils.dateToString((Date)result.getLastModificationDate()));
        }
        backingMap.put("lastModifierName", result.getLastModifier());
        backingMap.put("creatorName", result.getCreator());
        backingMap.put("title", result.getDisplayTitle());
        backingMap.put("urlPath", result.getUrlPath());
        backingMap.put("versionComment", result.getLastUpdateDescription());
        backingMap.put("type", result.getType());
        backingMap.put("contentBody", result.getContent());
        return new SearchResultWithExcerpt(backingMap);
    }
}

