/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.search.v2.lucene.mapper;

import com.atlassian.confluence.search.v2.lucene.LuceneQueryMapper;
import com.atlassian.confluence.search.v2.query.InSpaceQuery;
import java.util.List;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InSpaceQueryMapper
implements LuceneQueryMapper<InSpaceQuery> {
    public static final String SPACEKEY_FIELD = "spacekey";

    @Override
    public Query convertToLuceneQuery(InSpaceQuery inSpaceQuery) {
        if (inSpaceQuery.getParameters().size() == 1) {
            return new TermQuery(new Term(SPACEKEY_FIELD, (String)inSpaceQuery.getParameters().get(0)));
        }
        return this.makeBooleanQuery(inSpaceQuery.getParameters());
    }

    private Query makeBooleanQuery(List properties) {
        BooleanQuery query = new BooleanQuery();
        for (String s : properties) {
            query.add((Query)new TermQuery(new Term(SPACEKEY_FIELD, s)), BooleanClause.Occur.SHOULD);
        }
        return query;
    }
}

