/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.search.v2.query;

import com.atlassian.confluence.search.v2.SearchQuery;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class DateRangeQuery
implements SearchQuery {
    private static final String KEY = "dateRange";
    private final DateRange dateRange;
    private DateRangeQueryType dateRangeQueryType;

    public DateRangeQuery(Date from, Date to, boolean includeFrom, boolean includeTo, DateRangeQueryType dateRangeQueryType) {
        this(new DateRange(from, to, includeFrom, includeTo), dateRangeQueryType);
    }

    public DateRangeQuery(DateRange dateRange, DateRangeQueryType dateRangeQueryType) {
        this.dateRange = dateRange;
        this.dateRangeQueryType = dateRangeQueryType;
    }

    public String getKey() {
        return KEY;
    }

    public List getParameters() {
        return Arrays.asList(new Serializable[]{this.dateRange.getFrom(), this.dateRange.getTo(), Boolean.valueOf(this.dateRange.isIncludeFrom()), Boolean.valueOf(this.dateRange.isIncludeTo()), this.dateRangeQueryType});
    }

    public Date getFromDate() {
        return this.dateRange.getFrom();
    }

    public Date getToDate() {
        return this.dateRange.getTo();
    }

    public boolean isIncludeFrom() {
        return this.dateRange.isIncludeFrom();
    }

    public boolean isIncludeTo() {
        return this.dateRange.isIncludeTo();
    }

    public DateRangeQueryType getDateRangeQueryType() {
        return this.dateRangeQueryType;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        DateRangeQuery other = (DateRangeQuery)obj;
        return new EqualsBuilder().append((Object)this.dateRangeQueryType, (Object)other.dateRangeQueryType).append((Object)this.dateRange, (Object)other.dateRange).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(111, 37).append((Object)this.dateRangeQueryType).append((Object)this.dateRange).toHashCode();
    }

    public static class DateRange {
        private final Date from;
        private final Date to;
        private final boolean includeFrom;
        private final boolean includeTo;

        public DateRange(Date from, Date to, boolean includeFrom, boolean includeTo) {
            this.from = from;
            this.to = to;
            this.includeFrom = includeFrom;
            this.includeTo = includeTo;
        }

        public Date getFrom() {
            if (this.from == null) {
                return null;
            }
            return new Date(this.from.getTime());
        }

        public Date getTo() {
            if (this.to == null) {
                return null;
            }
            return new Date(this.to.getTime());
        }

        public boolean isIncludeFrom() {
            return this.includeFrom;
        }

        public boolean isIncludeTo() {
            return this.includeTo;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            DateRange other = (DateRange)obj;
            return new EqualsBuilder().append((Object)this.from, (Object)other.from).append((Object)this.to, (Object)other.to).append(this.includeFrom, other.includeFrom).append(this.includeTo, other.includeTo).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder(113, 37).append((Object)this.from).append((Object)this.to).append(this.includeFrom).append(this.includeTo).toHashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DateRangeQueryType {
        MODIFIED;

    }
}

