/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.search.v2.query;

import com.atlassian.confluence.search.v2.SearchQuery;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InSpaceQuery
implements SearchQuery {
    private static final String KEY = "inSpace";
    private List spaceKeys;

    public InSpaceQuery(String spaceKey) {
        this(Collections.singleton(spaceKey));
    }

    public InSpaceQuery(Set<String> spaceKeys) {
        if (spaceKeys == null) {
            throw new IllegalArgumentException("spaceKeys should not be null");
        }
        if (spaceKeys.isEmpty()) {
            throw new IllegalArgumentException("spaceKeys should not be empty");
        }
        if (spaceKeys.contains(null)) {
            throw new IllegalArgumentException("Null space key in spaces list");
        }
        this.spaceKeys = Collections.unmodifiableList(new ArrayList<String>(spaceKeys));
    }

    @Override
    public String getKey() {
        return KEY;
    }

    @Override
    public List getParameters() {
        return this.spaceKeys;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        InSpaceQuery other = (InSpaceQuery)obj;
        return new EqualsBuilder().append((Object)this.spaceKeys, (Object)other.spaceKeys).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(115, 37).append((Object)this.spaceKeys).toHashCode();
    }
}

