/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.search.v2.query;

import com.atlassian.confluence.search.service.SpaceCategoryEnum;
import com.atlassian.confluence.search.v2.SearchQuery;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpaceCategoryQuery
implements SearchQuery {
    private static final String KEY = "spaceCategory";
    private Set<SpaceCategoryEnum> spaceCategories;

    public SpaceCategoryQuery(Set<SpaceCategoryEnum> categories) {
        if (categories == null || categories.isEmpty()) {
            throw new IllegalArgumentException("categories must be supplied.");
        }
        this.spaceCategories = Collections.unmodifiableSet(categories);
    }

    public SpaceCategoryQuery(SpaceCategoryEnum category) {
        this(new HashSet<SpaceCategoryEnum>(Arrays.asList(category)));
    }

    @Override
    public String getKey() {
        return KEY;
    }

    @Override
    public List<String> getParameters() {
        ArrayList<String> categories = new ArrayList<String>(this.spaceCategories.size());
        for (SpaceCategoryEnum cat : this.spaceCategories) {
            categories.add(cat.getRepresentation());
        }
        return categories;
    }

    public Set<SpaceCategoryEnum> getSpaceCategories() {
        return this.spaceCategories;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        SpaceCategoryQuery other = (SpaceCategoryQuery)obj;
        return new EqualsBuilder().append(this.spaceCategories, other.spaceCategories).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(123, 37).append(this.spaceCategories).toHashCode();
    }
}

