/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.search.v2.query;

import com.atlassian.confluence.search.v2.BooleanOperator;
import com.atlassian.confluence.search.v2.SearchQuery;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class TextFieldQuery
implements SearchQuery {
    private static final String KEY = "textField";
    private String fieldName;
    private String rawQuery;
    private BooleanOperator operator;

    public TextFieldQuery(String fieldName, String rawQuery, BooleanOperator operator) {
        if (StringUtils.isBlank((String)fieldName)) {
            throw new IllegalArgumentException("Fieldname is required.");
        }
        if (StringUtils.isBlank((String)rawQuery)) {
            throw new IllegalArgumentException("Raw query is required.");
        }
        if (operator == null) {
            throw new IllegalArgumentException("Operator is required.");
        }
        this.rawQuery = rawQuery;
        this.fieldName = fieldName;
        this.operator = operator;
    }

    public String getKey() {
        return KEY;
    }

    public List getParameters() {
        return Arrays.asList(this.fieldName, this.rawQuery);
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getRawQuery() {
        return this.rawQuery;
    }

    public BooleanOperator getOperator() {
        return this.operator;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        TextFieldQuery other = (TextFieldQuery)obj;
        return new EqualsBuilder().append((Object)this.fieldName, (Object)other.fieldName).append((Object)this.operator, (Object)other.operator).append((Object)this.rawQuery, (Object)other.rawQuery).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(125, 37).append((Object)this.fieldName).append((Object)this.operator).append((Object)this.rawQuery).hashCode();
    }
}

