/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.security;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheFactory;
import com.atlassian.confluence.security.DefaultSpacePermissionManager;
import com.atlassian.confluence.security.SpacePermission;
import com.atlassian.confluence.spaces.Space;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.log4j.Logger;

public class CachingSpacePermissionManager
extends DefaultSpacePermissionManager {
    public static final String CACHE_KEY = CachingSpacePermissionManager.class.getName() + ".permissions";
    private Logger log = Logger.getLogger(CachingSpacePermissionManager.class);
    private boolean lookAheadEnabled = false;
    private CacheFactory cacheFactory;

    public boolean permissionExists(SpacePermission permission) {
        return this.findPermission(permission);
    }

    protected void savePermissionToDao(SpacePermission permission) {
        super.savePermissionToDao(permission);
        this.removePermissionFromCache(permission);
    }

    protected void removePermissionFromDao(SpacePermission realPermission) {
        super.removePermissionFromDao(realPermission);
        this.removePermissionFromCache(realPermission);
    }

    public void removeAllPermissions(Space space) {
        List permissions = this.getAllSpacePermissions(space);
        this.log.debug((Object)("remove all permissions for space: " + space.getName()));
        super.removeAllPermissions(space);
        this.removePermissionsFromCache(permissions);
    }

    private List getAllSpacePermissions(Space space) {
        this.spacePermissionDao.refresh(space);
        return new ArrayList(space.getPermissions());
    }

    private void removePermissionsFromCache(Collection permissions) {
        for (SpacePermission permission : permissions) {
            this.removePermissionFromCache(permission);
        }
    }

    public void setCacheFactory(CacheFactory cacheFactory) {
        this.cacheFactory = cacheFactory;
    }

    private Cache getCache() {
        return this.cacheFactory.getCache(CACHE_KEY);
    }

    private void removePermissionFromCache(SpacePermission permission) {
        try {
            this.getCache().remove((Object)new SpacePermissionCacheKey(permission));
        }
        catch (Exception e) {
            this.log.error((Object)("There was a problem removing the permission '" + permission + "' from the cache: "), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private void addPermissionToCache(SpacePermission permission, boolean exists) {
        this.addPermissionsToCache(Collections.singletonList(permission), exists);
    }

    private void addPermissionsToCache(List permissions, boolean exists) {
        for (SpacePermission spacePermission : permissions) {
            this.getCache().put((Object)new SpacePermissionCacheKey(spacePermission), (Object)exists);
        }
    }

    private boolean findPermission(SpacePermission permission) {
        Boolean cachedResult = (Boolean)this.getCache().get((Object)new SpacePermissionCacheKey(permission));
        if (cachedResult != null) {
            this.log.debug((Object)("HIT retrieiving '" + permission + "' from the cache"));
            return cachedResult;
        }
        this.log.debug((Object)("MISS retrieiving '" + permission + "' from the cache"));
        boolean result = this.spacePermissionDao.hasPermission(permission);
        this.addPermissionToCache(permission, result);
        if (this.isLookAheadEnabled()) {
            this.doLookAheadCache(permission);
        }
        return result;
    }

    private void doLookAheadCache(SpacePermission permission) {
        List permissions = this.spacePermissionDao.findPermissionTypes(permission);
        this.log.debug((Object)("Permissions Look Ahead - found " + permissions.size() + " permissions for " + permission));
        this.addPermissionsToCache(permissions, true);
    }

    public void flushCaches() {
        super.flushCaches();
        try {
            this.getCache().removeAll();
        }
        catch (Exception e) {
            this.log.error((Object)"Exception while flushing permissions cache", (Throwable)e);
            throw new RuntimeException("Exception while flushing permissions cache", e);
        }
    }

    public boolean isLookAheadEnabled() {
        return this.lookAheadEnabled;
    }

    public void setLookAheadEnabled(boolean lookAheadEnabled) {
        this.lookAheadEnabled = lookAheadEnabled;
    }

    static class SpacePermissionCacheKey
    implements Serializable {
        private final String type;
        private final long spaceId;
        private final String groupname;
        private final String username;

        public SpacePermissionCacheKey(SpacePermission spacePermission) {
            this.type = spacePermission.getType();
            this.spaceId = spacePermission.getSpace() == null ? 0L : spacePermission.getSpaceId();
            this.groupname = spacePermission.getGroup();
            this.username = spacePermission.getUserName();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof SpacePermissionCacheKey)) {
                return false;
            }
            SpacePermissionCacheKey other = (SpacePermissionCacheKey)obj;
            return new EqualsBuilder().append((Object)this.type, (Object)other.type).append(this.spaceId, other.spaceId).append((Object)this.groupname, (Object)other.groupname).append((Object)this.username, (Object)other.username).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder(17, 37).append((Object)this.type).append(this.spaceId).append((Object)this.groupname).append((Object)this.username).toHashCode();
        }
    }
}

