/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.security;

import com.atlassian.config.util.BootstrapUtils;
import com.atlassian.confluence.security.ConfluenceGroupCache;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.seraph.auth.GroupRoleMapper;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.user.User;
import java.security.Principal;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;

public class ConfluenceRoleMapper
extends GroupRoleMapper {
    public static final String ADMIN_JSP_ROLE = "admin_jsp_role";
    public static final String CONFLUENCE_ADMIN_ROLE = "confluenceadmin_seraph_role";
    private PermissionManager permissionManager;
    private UserAccessor userAccessor;

    public boolean hasRole(Principal user, HttpServletRequest request, String role) {
        if (user instanceof User && BootstrapUtils.getBootstrapManager() != null && BootstrapUtils.getBootstrapManager().isSetupComplete()) {
            if (ADMIN_JSP_ROLE.equals(role)) {
                String url = request.getServletPath() + (request.getPathInfo() == null ? "" : request.getPathInfo());
                if (url.endsWith("default.jsp")) {
                    return this.getPermissionManager().hasPermission((User)user, Permission.ADMINISTER, PermissionManager.TARGET_APPLICATION);
                }
                return this.getPermissionManager().hasPermission((User)user, Permission.ADMINISTER, PermissionManager.TARGET_SYSTEM);
            }
            if (CONFLUENCE_ADMIN_ROLE.equals(role)) {
                return this.getPermissionManager().hasPermission((User)user, Permission.ADMINISTER, PermissionManager.TARGET_APPLICATION);
            }
        }
        return this.seraphHasRole(user, request, role);
    }

    private boolean seraphHasRole(Principal user, HttpServletRequest request, String role) {
        Collection groups = ConfluenceGroupCache.getGroups(request, this.getUserAccessor());
        if (groups == null && role == null) {
            return true;
        }
        if (groups == null) {
            return false;
        }
        return groups.contains(role);
    }

    private PermissionManager getPermissionManager() {
        if (this.permissionManager == null && ContainerManager.isContainerSetup()) {
            this.permissionManager = (PermissionManager)ContainerManager.getComponent((String)"permissionManager");
        }
        return this.permissionManager;
    }

    private UserAccessor getUserAccessor() {
        if (this.userAccessor == null && ContainerManager.isContainerSetup()) {
            this.userAccessor = (UserAccessor)ContainerManager.getComponent((String)"userAccessor");
        }
        return this.userAccessor;
    }
}

