/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.security;

import com.atlassian.confluence.security.CaptchaManager;
import com.atlassian.confluence.security.ConfluenceCaptchaEngine;
import com.atlassian.confluence.security.ConfluenceImageCaptchaService;
import com.atlassian.confluence.setup.settings.Settings;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.user.Group;
import com.atlassian.user.User;
import com.atlassian.user.search.page.Pager;
import com.octo.captcha.engine.CaptchaEngine;
import com.octo.captcha.service.CaptchaServiceException;
import com.octo.captcha.service.captchastore.CaptchaStore;
import com.octo.captcha.service.image.ImageCaptchaService;
import java.util.Collection;
import java.util.HashSet;
import java.util.Random;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Category;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class DefaultCaptchaManager
implements CaptchaManager,
InitializingBean,
DisposableBean {
    private static final Random RANDOM = new Random();
    public static final Category log = Category.getInstance(DefaultCaptchaManager.class);
    private ImageCaptchaService imageCaptchaService;
    private SettingsManager settingsManager;
    private UserAccessor userAccessor;
    private CaptchaStore captchaStore;

    public void setCaptchaStore(CaptchaStore captchaStore) {
        this.captchaStore = captchaStore;
    }

    public void afterPropertiesSet() throws Exception {
        try {
            if (this.imageCaptchaService == null) {
                this.imageCaptchaService = new ConfluenceImageCaptchaService((CaptchaEngine)new ConfluenceCaptchaEngine(), this.captchaStore);
            }
        }
        catch (Throwable t) {
            log.error((Object)("Could not initialise CAPTCHA service. The most likely reason for thisis that Java's graphics subsystem is not properly configured. Try startingConfluence's JVM with the -Djava.awt.headless=true option. " + t.getMessage()), t);
        }
    }

    public void destroy() throws Exception {
    }

    public boolean isCaptchaAvailable() {
        return this.imageCaptchaService != null;
    }

    public boolean validateCaptcha(String captchaId, String captchaResponse) {
        if (!this.showCaptchaForCurrentUser()) {
            return true;
        }
        if (StringUtils.isBlank((String)captchaId)) {
            return false;
        }
        Boolean isResponseCorrect = Boolean.FALSE;
        try {
            isResponseCorrect = this.imageCaptchaService.validateResponseForID(captchaId, (Object)captchaResponse);
        }
        catch (CaptchaServiceException e) {
            // empty catch block
        }
        return isResponseCorrect;
    }

    public boolean isCaptchaEnabled() {
        return this.settingsManager.getGlobalSettings().getCaptchaSettings().isEnableCaptcha();
    }

    public void setCaptchaEnabled(boolean value) {
        Settings settings = this.settingsManager.getGlobalSettings();
        settings.getCaptchaSettings().setEnableCaptcha(value);
        this.settingsManager.updateGlobalSettings(settings);
    }

    public void excludeNone() {
        this.setExclude("none");
    }

    public void excludeRegisteredUsers() {
        this.setExclude("registered");
    }

    public void excludeGroups() {
        this.setExclude("groups");
    }

    public String getExclude() {
        return this.settingsManager.getGlobalSettings().getCaptchaSettings().getExclude();
    }

    public void setExclude(String value) {
        Settings settings = this.settingsManager.getGlobalSettings();
        settings.getCaptchaSettings().setExclude(value);
        this.settingsManager.updateGlobalSettings(settings);
    }

    public void setCaptchaGroups(Collection groupList) {
        Settings settings = this.settingsManager.getGlobalSettings();
        HashSet captchaGroups = new HashSet(groupList);
        settings.getCaptchaSettings().setCaptchaGroups(captchaGroups);
        this.settingsManager.updateGlobalSettings(settings);
    }

    public Collection addCaptchaGroups(Collection groupList) {
        Settings settings = this.settingsManager.getGlobalSettings();
        HashSet captchaGroups = new HashSet(settings.getCaptchaSettings().getCaptchaGroups());
        captchaGroups.addAll(groupList);
        settings.getCaptchaSettings().setCaptchaGroups(captchaGroups);
        this.settingsManager.updateGlobalSettings(settings);
        return captchaGroups;
    }

    public void removeCaptchaGroup(String group) {
        Settings settings = this.settingsManager.getGlobalSettings();
        Collection captchaGroups = settings.getCaptchaSettings().getCaptchaGroups();
        captchaGroups.remove(group);
        settings.getCaptchaSettings().setCaptchaGroups(captchaGroups);
        this.settingsManager.updateGlobalSettings(settings);
    }

    public boolean showCaptchaForCurrentUser() {
        User user = AuthenticatedUserThreadLocal.getUser();
        Settings settings = this.settingsManager.getGlobalSettings();
        Collection captchaGroups = settings.getCaptchaSettings().getCaptchaGroups();
        if (this.isCaptchaEnabled()) {
            if (user == null) {
                return true;
            }
            if ("registered".equals(settings.getCaptchaSettings().getExclude())) {
                return false;
            }
            if ("groups".equals(settings.getCaptchaSettings().getExclude())) {
                if (captchaGroups.size() == 0) {
                    return true;
                }
                Pager usersPager = this.userAccessor.getGroups(user);
                for (Group group : usersPager) {
                    if (!captchaGroups.contains(group.getName())) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public void setSettingsManager(SettingsManager settingsManager) {
        this.settingsManager = settingsManager;
    }

    public UserAccessor getUserAccessor() {
        return this.userAccessor;
    }

    public void setUserAccessor(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }

    public void setImageCaptchaService(ImageCaptchaService imageCaptchaService) {
        this.imageCaptchaService = imageCaptchaService;
    }

    public ImageCaptchaService getImageCaptchaService() {
        return this.imageCaptchaService;
    }

    public String generateCaptchaId() {
        return String.valueOf(RANDOM.nextInt());
    }
}

