/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.security;

import com.atlassian.confluence.security.PermissionDelegate;
import com.atlassian.user.User;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Locale;

public abstract class Permission
implements Serializable {
    public static final Permission VIEW = new Permission("VIEW"){

        public boolean checkAgainst(PermissionDelegate delegate, User user, Object target) {
            return delegate.canView(user, target);
        }
    };
    public static final Permission EDIT = new Permission("EDIT"){

        public boolean checkAgainst(PermissionDelegate delegate, User user, Object target) {
            return delegate.canEdit(user, target);
        }
    };
    public static final Permission SET_PERMISSIONS = new Permission("SET_PERMISSIONS"){

        public boolean checkAgainst(PermissionDelegate delegate, User user, Object target) {
            return delegate.canSetPermissions(user, target);
        }
    };
    public static final Permission REMOVE = new Permission("REMOVE"){

        public boolean checkAgainst(PermissionDelegate delegate, User user, Object target) {
            return delegate.canRemove(user, target);
        }
    };
    public static final Permission EXPORT = new Permission("EXPORT"){

        public boolean checkAgainst(PermissionDelegate delegate, User user, Object target) {
            return delegate.canExport(user, target);
        }
    };
    public static final Permission ADMINISTER = new Permission("ADMINISTER"){

        public boolean checkAgainst(PermissionDelegate delegate, User user, Object target) {
            return delegate.canAdminister(user, target);
        }
    };
    private final String myName;
    private static final Permission[] ALL_PERMISSIONS = new Permission[]{VIEW, EDIT, SET_PERMISSIONS, REMOVE, EXPORT, ADMINISTER};

    public static Permission forName(String permissionName) {
        String upperName = permissionName.toUpperCase(Locale.ENGLISH);
        for (int i = 0; i < ALL_PERMISSIONS.length; ++i) {
            Permission permission = ALL_PERMISSIONS[i];
            if (!permission.toString().equals(upperName)) continue;
            return permission;
        }
        throw new IllegalArgumentException("Permission not found with name: " + permissionName);
    }

    private Permission(String name) {
        this.myName = name;
    }

    public String toString() {
        return this.myName;
    }

    public abstract boolean checkAgainst(PermissionDelegate var1, User var2, Object var3);

    public final boolean equals(Object that) {
        return super.equals(that);
    }

    public final int hashCode() {
        return super.hashCode();
    }

    Object readResolve() throws ObjectStreamException {
        for (int i = 0; i < ALL_PERMISSIONS.length; ++i) {
            Permission permission = ALL_PERMISSIONS[i];
            if (!this.myName.equals(permission.myName)) continue;
            return permission;
        }
        throw new IllegalStateException("No permission can be deserialized with name: " + this.myName);
    }
}

