/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.security;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.security.ImplementsIsPermitted;
import com.atlassian.confluence.security.PermissionCheckDispatcherResultCache;
import com.atlassian.spring.container.ContainerManager;
import com.opensymphony.webwork.WebWorkStatics;
import com.opensymphony.webwork.dispatcher.ServletDispatcher;
import com.opensymphony.xwork.Action;
import com.opensymphony.xwork.ActionContext;
import com.opensymphony.xwork.ActionInvocation;
import com.opensymphony.xwork.ActionProxy;
import com.opensymphony.xwork.ActionProxyFactory;
import com.opensymphony.xwork.util.OgnlValueStack;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.log4j.Category;

public class PermissionCheckDispatcher
implements WebWorkStatics {
    Category log = Category.getInstance(PermissionCheckDispatcher.class);
    private PermissionCheckDispatcherResultCache permissionCheckDispatcherResultCache;

    public void setPermissionCheckDispatcherResultCache(PermissionCheckDispatcherResultCache permissionCheckDispatcherResultCache) {
        this.permissionCheckDispatcherResultCache = permissionCheckDispatcherResultCache;
    }

    public boolean isPermitted(String url) {
        try {
            Boolean cachedResult;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Checking " + url));
            }
            if (this.permissionCheckDispatcherResultCache != null && (cachedResult = this.permissionCheckDispatcherResultCache.getFromCache(url)) != null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Found " + cachedResult + " in cache for " + url));
                }
                return cachedResult;
            }
            Boolean isPermitted = this.isPermittedForUrl(url);
            if (this.permissionCheckDispatcherResultCache != null && isPermitted != null) {
                this.permissionCheckDispatcherResultCache.putInCache(url, isPermitted);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Cache miss: " + isPermitted + " for " + url));
            }
            return isPermitted == null ? false : isPermitted;
        }
        catch (Exception e) {
            this.log.error((Object)("Unable to determine permissions for " + url + ": " + e), (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Boolean isPermittedForUrl(String url) {
        Boolean bl;
        String actionName = null;
        ActionInvocation originalActionInvocation = ActionContext.getContext().getActionInvocation();
        Map originalApplication = ActionContext.getContext().getApplication();
        Map originalContextMap = ActionContext.getContext().getContextMap();
        Locale originalLocale = ActionContext.getContext().getLocale();
        String originalName = ActionContext.getContext().getName();
        Map originalParameters = ActionContext.getContext().getParameters();
        Map originalSession = ActionContext.getContext().getSession();
        OgnlValueStack valueStack = ActionContext.getContext().getValueStack();
        ActionProxy proxy = null;
        Object originalAction = null;
        boolean valueStackNotEmpty = valueStack.size() > 0;
        try {
            boolean result;
            String actionResult;
            if (valueStackNotEmpty) {
                originalAction = valueStack.pop();
            }
            String urlWithoutParameters = url;
            if (url.indexOf("?") > 0) {
                urlWithoutParameters = urlWithoutParameters.substring(0, url.indexOf("?"));
            }
            String namespace = ServletDispatcher.getNamespaceFromServletPath((String)urlWithoutParameters);
            actionName = this.getActionName(urlWithoutParameters);
            HashMap<String, Map> newContextMap = new HashMap<String, Map>(ActionContext.getContext().getContextMap());
            newContextMap.put("com.opensymphony.xwork.ActionContext.parameters", this.getParameterMap(url));
            proxy = ActionProxyFactory.getFactory().createActionProxy(namespace, actionName, newContextMap, false);
            Action action = proxy.getAction();
            if (action instanceof ConfluenceActionSupport) {
                ((ConfluenceActionSupport)action).setPermissionCheck(true);
            }
            if ((actionResult = proxy.execute()).equals("true")) {
                result = true;
            } else if (actionResult.equals("false")) {
                result = false;
            } else if (actionResult.equals("notpermitted")) {
                result = false;
            } else {
                throw new IllegalStateException("Unknown permission state " + actionResult);
            }
            bl = result;
            Object var22_23 = null;
        }
        catch (Exception e) {
            Boolean bl2;
            try {
                this.log.error((Object)("Error determining permissions for url " + url + " (Action : " + actionName + ")"), (Throwable)e);
                bl2 = null;
                Object var22_24 = null;
            }
            catch (Throwable throwable) {
                Object var22_25 = null;
                if (valueStack.size() > 0) {
                    valueStack.pop();
                }
                if (proxy != null) {
                    proxy.getInvocation().getInvocationContext().setParameters(originalParameters);
                }
                if (valueStackNotEmpty) {
                    valueStack.push(originalAction);
                }
                ActionContext.getContext().setActionInvocation(originalActionInvocation);
                ActionContext.getContext().setApplication(originalApplication);
                ActionContext.getContext().setContextMap(originalContextMap);
                ActionContext.getContext().setLocale(originalLocale);
                ActionContext.getContext().setName(originalName);
                ActionContext.getContext().setParameters(originalParameters);
                ActionContext.getContext().setSession(originalSession);
                ActionContext.getContext().setValueStack(valueStack);
                throw throwable;
            }
            if (valueStack.size() > 0) {
                valueStack.pop();
            }
            if (proxy != null) {
                proxy.getInvocation().getInvocationContext().setParameters(originalParameters);
            }
            if (valueStackNotEmpty) {
                valueStack.push(originalAction);
            }
            ActionContext.getContext().setActionInvocation(originalActionInvocation);
            ActionContext.getContext().setApplication(originalApplication);
            ActionContext.getContext().setContextMap(originalContextMap);
            ActionContext.getContext().setLocale(originalLocale);
            ActionContext.getContext().setName(originalName);
            ActionContext.getContext().setParameters(originalParameters);
            ActionContext.getContext().setSession(originalSession);
            ActionContext.getContext().setValueStack(valueStack);
            return bl2;
        }
        if (valueStack.size() > 0) {
            valueStack.pop();
        }
        if (proxy != null) {
            proxy.getInvocation().getInvocationContext().setParameters(originalParameters);
        }
        if (valueStackNotEmpty) {
            valueStack.push(originalAction);
        }
        ActionContext.getContext().setActionInvocation(originalActionInvocation);
        ActionContext.getContext().setApplication(originalApplication);
        ActionContext.getContext().setContextMap(originalContextMap);
        ActionContext.getContext().setLocale(originalLocale);
        ActionContext.getContext().setName(originalName);
        ActionContext.getContext().setParameters(originalParameters);
        ActionContext.getContext().setSession(originalSession);
        ActionContext.getContext().setValueStack(valueStack);
        return bl;
    }

    private Map getParameterMap(String url) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        int dotActionQMarkIdx = url.lastIndexOf(".action?");
        if (dotActionQMarkIdx != -1) {
            String paramsStr = url.substring(dotActionQMarkIdx + 8);
            StringTokenizer params = new StringTokenizer(paramsStr, "&", false);
            while (params.hasMoreTokens()) {
                String paramStr = params.nextToken();
                int equalsIdx = paramStr.indexOf(61);
                if (equalsIdx < 0) continue;
                String paramName = paramStr.substring(0, equalsIdx);
                String paramValue = equalsIdx != -1 ? paramStr.substring(equalsIdx + 1) : "";
                parameters.put(paramName, paramValue);
            }
        }
        return parameters;
    }

    String getActionName(String name) {
        String nameCopy = name;
        if (name.indexOf(63) != -1) {
            nameCopy = nameCopy.substring(0, name.indexOf(63));
        } else if (name.indexOf(59) != -1) {
            nameCopy = nameCopy.substring(0, name.indexOf(59));
        }
        int beginIdx = nameCopy.lastIndexOf("/");
        int endIdx = nameCopy.lastIndexOf(".action");
        if (endIdx == -1 || !nameCopy.substring(endIdx, nameCopy.length()).equals(".action")) {
            return name;
        }
        int start = beginIdx == -1 ? 0 : beginIdx + 1;
        int end = endIdx == -1 ? name.length() : endIdx;
        return name.substring(start, end);
    }

    public void clearCache() {
        if (this.permissionCheckDispatcherResultCache != null) {
            this.permissionCheckDispatcherResultCache.flush();
        }
    }

    public boolean isPermittedForAjax(String springRef, List params) {
        Object bean = ContainerManager.getComponent((String)springRef);
        if (bean == null) {
            throw new RuntimeException("No bean found for id '" + springRef + "'");
        }
        if (!(bean instanceof ImplementsIsPermitted)) {
            throw new RuntimeException("Bean with id '" + springRef + "' does not implement ImplementsIsPermitted");
        }
        return ((ImplementsIsPermitted)bean).isPermitted(params);
    }
}

